/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.RamenDining: ImageVector
    get() {
        if (_ramenDining != null) {
            return _ramenDining!!
        }
        _ramenDining = materialIcon(name = "Rounded.RamenDining") {
            materialPath {
                moveTo(22.0f, 2.84f)
                lineTo(22.0f, 2.84f)
                curveToRelative(0.0f, -0.45f, -0.39f, -0.79f, -0.83f, -0.75f)
                lineTo(4.89f, 3.9f)
                curveTo(4.38f, 3.95f, 4.0f, 4.38f, 4.0f, 4.89f)
                verticalLineTo(12.0f)
                horizontalLineTo(3.08f)
                curveToRelative(-0.6f, 0.0f, -1.08f, 0.53f, -1.0f, 1.13f)
                curveTo(2.52f, 16.33f, 4.83f, 19.0f, 8.0f, 20.25f)
                verticalLineTo(21.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(6.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(-0.75f)
                curveToRelative(3.17f, -1.25f, 5.48f, -3.92f, 5.92f, -7.12f)
                curveToRelative(0.08f, -0.6f, -0.4f, -1.13f, -1.0f, -1.13f)
                horizontalLineTo(10.5f)
                verticalLineTo(8.0f)
                horizontalLineToRelative(10.75f)
                curveTo(21.66f, 8.0f, 22.0f, 7.66f, 22.0f, 7.25f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, -0.41f, -0.34f, -0.75f, -0.75f, -0.75f)
                horizontalLineTo(10.5f)
                verticalLineTo(4.78f)
                lineToRelative(10.83f, -1.19f)
                curveTo(21.71f, 3.54f, 22.0f, 3.22f, 22.0f, 2.84f)
                close()
                moveTo(6.5f, 5.22f)
                verticalLineTo(6.5f)
                horizontalLineToRelative(-1.0f)
                verticalLineTo(5.34f)
                lineTo(6.5f, 5.22f)
                close()
                moveTo(5.5f, 8.0f)
                horizontalLineToRelative(1.0f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineTo(8.0f)
                close()
                moveTo(9.0f, 12.0f)
                horizontalLineTo(8.0f)
                verticalLineTo(8.0f)
                horizontalLineToRelative(1.0f)
                verticalLineTo(12.0f)
                close()
                moveTo(9.0f, 6.5f)
                horizontalLineTo(8.0f)
                verticalLineTo(5.06f)
                lineToRelative(1.0f, -0.11f)
                verticalLineTo(6.5f)
                close()
            }
        }
        return _ramenDining!!
    }

private var _ramenDining: ImageVector? = null
