/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.HdrOff: ImageVector
    get() {
        if (_hdrOff != null) {
            return _hdrOff!!
        }
        _hdrOff = materialIcon(name = "Sharp.HdrOff") {
            materialPath {
                moveTo(17.5f, 15.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(1.1f)
                lineToRelative(0.9f, 2.0f)
                lineTo(21.0f, 15.0f)
                lineToRelative(-0.9f, -2.1f)
                horizontalLineToRelative(0.9f)
                lineTo(21.0f, 9.0f)
                horizontalLineToRelative(-5.0f)
                verticalLineToRelative(4.86f)
                lineTo(17.14f, 15.0f)
                horizontalLineToRelative(0.36f)
                close()
                moveTo(17.5f, 10.5f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-1.0f)
                close()
                moveTo(13.0f, 10.5f)
                verticalLineToRelative(0.36f)
                lineToRelative(1.5f, 1.5f)
                lineTo(14.5f, 10.5f)
                curveToRelative(0.0f, -0.8f, -0.7f, -1.5f, -1.5f, -1.5f)
                horizontalLineToRelative(-1.86f)
                lineToRelative(1.5f, 1.5f)
                lineTo(13.0f, 10.5f)
                close()
                moveTo(2.51f, 2.49f)
                lineTo(1.45f, 3.55f)
                lineTo(6.9f, 9.0f)
                horizontalLineToRelative(-0.4f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-2.0f)
                lineTo(4.5f, 9.0f)
                lineTo(3.0f, 9.0f)
                verticalLineToRelative(6.0f)
                horizontalLineToRelative(1.5f)
                verticalLineToRelative(-2.5f)
                horizontalLineToRelative(2.0f)
                lineTo(6.5f, 15.0f)
                lineTo(8.0f, 15.0f)
                verticalLineToRelative(-4.9f)
                lineToRelative(1.5f, 1.5f)
                lineTo(9.5f, 15.0f)
                horizontalLineToRelative(3.4f)
                lineToRelative(7.6f, 7.6f)
                lineToRelative(1.06f, -1.06f)
                close()
            }
        }
        return _hdrOff!!
    }

private var _hdrOff: ImageVector? = null
