/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.PriceCheck: ImageVector
    get() {
        if (_priceCheck != null) {
            return _priceCheck!!
        }
        _priceCheck = materialIcon(name = "Sharp.PriceCheck") {
            materialPath {
                moveTo(11.0f, 8.0f)
                lineToRelative(-5.0f, 0.0f)
                lineToRelative(0.0f, -2.0f)
                lineToRelative(5.0f, 0.0f)
                lineToRelative(0.0f, -2.0f)
                lineToRelative(-2.5f, 0.0f)
                lineToRelative(0.0f, -1.0f)
                lineToRelative(-2.0f, 0.0f)
                lineToRelative(0.0f, 1.0f)
                lineToRelative(-2.5f, 0.0f)
                lineToRelative(0.0f, 6.0f)
                lineToRelative(5.0f, 0.0f)
                lineToRelative(0.0f, 2.0f)
                lineToRelative(-5.0f, 0.0f)
                lineToRelative(0.0f, 2.0f)
                lineToRelative(2.5f, 0.0f)
                lineToRelative(0.0f, 1.0f)
                lineToRelative(2.0f, 0.0f)
                lineToRelative(0.0f, -1.0f)
                lineToRelative(2.5f, 0.0f)
                close()
            }
            materialPath {
                moveTo(19.59f, 12.52f)
                lineToRelative(-5.66f, 5.65f)
                lineToRelative(-2.83f, -2.83f)
                lineToRelative(-1.41f, 1.42f)
                lineToRelative(4.24f, 4.24f)
                lineToRelative(7.07f, -7.07f)
                close()
            }
        }
        return _priceCheck!!
    }

private var _priceCheck: ImageVector? = null
