/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.VideoChat: ImageVector
    get() {
        if (_videoChat != null) {
            return _videoChat!!
        }
        _videoChat = materialIcon(name = "Sharp.VideoChat") {
            materialPath {
                moveTo(2.0f, 2.0f)
                verticalLineToRelative(20.0f)
                lineToRelative(4.0f, -4.0f)
                horizontalLineToRelative(16.0f)
                verticalLineTo(2.0f)
                horizontalLineTo(2.0f)
                close()
                moveTo(17.0f, 13.0f)
                lineToRelative(-2.0f, -1.99f)
                verticalLineTo(14.0f)
                horizontalLineTo(7.0f)
                verticalLineTo(6.0f)
                horizontalLineToRelative(8.0f)
                verticalLineToRelative(2.99f)
                lineTo(17.0f, 7.0f)
                verticalLineTo(13.0f)
                close()
            }
        }
        return _videoChat!!
    }

private var _videoChat: ImageVector? = null
