/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.Person2: ImageVector
    get() {
        if (_person2 != null) {
            return _person2!!
        }
        _person2 = materialIcon(name = "TwoTone.Person2") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(13.9f, 7.59f)
                curveTo(13.74f, 6.67f, 12.94f, 6.0f, 12.0f, 6.0f)
                reflectiveCurveToRelative(-1.74f, 0.67f, -1.9f, 1.59f)
                lineTo(9.78f, 10.0f)
                horizontalLineToRelative(4.44f)
                lineTo(13.9f, 7.59f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(17.48f, 16.34f)
                curveTo(16.29f, 15.73f, 14.37f, 15.0f, 12.0f, 15.0f)
                curveToRelative(-2.37f, 0.0f, -4.29f, 0.73f, -5.48f, 1.34f)
                curveTo(6.2f, 16.5f, 6.0f, 16.84f, 6.0f, 17.22f)
                verticalLineTo(18.0f)
                horizontalLineToRelative(12.0f)
                verticalLineToRelative(-0.78f)
                curveTo(18.0f, 16.84f, 17.8f, 16.5f, 17.48f, 16.34f)
                close()
            }
            materialPath {
                moveTo(18.39f, 14.56f)
                curveTo(16.71f, 13.7f, 14.53f, 13.0f, 12.0f, 13.0f)
                curveToRelative(-2.53f, 0.0f, -4.71f, 0.7f, -6.39f, 1.56f)
                curveTo(4.61f, 15.07f, 4.0f, 16.1f, 4.0f, 17.22f)
                verticalLineTo(20.0f)
                horizontalLineToRelative(16.0f)
                verticalLineToRelative(-2.78f)
                curveTo(20.0f, 16.1f, 19.39f, 15.07f, 18.39f, 14.56f)
                close()
                moveTo(18.0f, 18.0f)
                horizontalLineTo(6.0f)
                verticalLineToRelative(-0.78f)
                curveToRelative(0.0f, -0.38f, 0.2f, -0.72f, 0.52f, -0.88f)
                curveTo(7.71f, 15.73f, 9.63f, 15.0f, 12.0f, 15.0f)
                curveToRelative(2.37f, 0.0f, 4.29f, 0.73f, 5.48f, 1.34f)
                curveTo(17.8f, 16.5f, 18.0f, 16.84f, 18.0f, 17.22f)
                verticalLineTo(18.0f)
                close()
            }
            materialPath {
                moveTo(9.78f, 12.0f)
                horizontalLineToRelative(4.44f)
                curveToRelative(1.21f, 0.0f, 2.14f, -1.06f, 1.98f, -2.26f)
                lineToRelative(-0.32f, -2.45f)
                curveTo(15.57f, 5.39f, 13.92f, 4.0f, 12.0f, 4.0f)
                reflectiveCurveTo(8.43f, 5.39f, 8.12f, 7.29f)
                lineTo(7.8f, 9.74f)
                curveTo(7.64f, 10.94f, 8.57f, 12.0f, 9.78f, 12.0f)
                close()
                moveTo(10.1f, 7.59f)
                curveTo(10.26f, 6.67f, 11.06f, 6.0f, 12.0f, 6.0f)
                reflectiveCurveToRelative(1.74f, 0.67f, 1.9f, 1.59f)
                lineTo(14.22f, 10.0f)
                horizontalLineTo(9.78f)
                lineTo(10.1f, 7.59f)
                close()
            }
        }
        return _person2!!
    }

private var _person2: ImageVector? = null
