/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.TextRotationAngledown: ImageVector
    get() {
        if (_textRotationAngledown != null) {
            return _textRotationAngledown!!
        }
        _textRotationAngledown = materialIcon(name = "Outlined.TextRotationAngledown") {
            materialPath {
                moveTo(15.0f, 21.0f)
                verticalLineToRelative(-4.24f)
                lineToRelative(-1.41f, 1.41f)
                lineToRelative(-9.2f, -9.19f)
                lineToRelative(-1.41f, 1.41f)
                lineToRelative(9.19f, 9.19f)
                lineTo(10.76f, 21.0f)
                lineTo(15.0f, 21.0f)
                close()
                moveTo(11.25f, 8.48f)
                lineToRelative(3.54f, 3.54f)
                lineToRelative(-0.92f, 2.19f)
                lineToRelative(1.48f, 1.48f)
                lineToRelative(4.42f, -11.14f)
                lineToRelative(-1.06f, -1.05f)
                lineTo(7.57f, 7.92f)
                lineTo(9.06f, 9.4f)
                lineToRelative(2.19f, -0.92f)
                close()
                moveTo(17.84f, 5.43f)
                lineToRelative(-2.23f, 4.87f)
                lineToRelative(-2.64f, -2.64f)
                lineToRelative(4.87f, -2.23f)
                close()
            }
        }
        return _textRotationAngledown!!
    }

private var _textRotationAngledown: ImageVector? = null
