/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Quickreply: ImageVector
    get() {
        if (_quickreply != null) {
            return _quickreply!!
        }
        _quickreply = materialIcon(name = "Rounded.Quickreply") {
            materialPath {
                moveTo(22.0f, 4.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                horizontalLineTo(4.0f)
                curveTo(2.9f, 2.0f, 2.01f, 2.9f, 2.01f, 4.0f)
                lineTo(2.0f, 22.0f)
                lineToRelative(4.0f, -4.0f)
                horizontalLineToRelative(9.0f)
                verticalLineToRelative(-7.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                horizontalLineToRelative(6.0f)
                verticalLineTo(4.0f)
                close()
            }
            materialPath {
                moveTo(21.69f, 16.0f)
                horizontalLineTo(20.3f)
                lineToRelative(1.4f, -3.3f)
                curveToRelative(0.14f, -0.33f, -0.1f, -0.7f, -0.46f, -0.7f)
                horizontalLineTo(17.5f)
                curveToRelative(-0.28f, 0.0f, -0.5f, 0.22f, -0.5f, 0.5f)
                verticalLineToRelative(5.0f)
                curveToRelative(0.0f, 0.28f, 0.22f, 0.5f, 0.5f, 0.5f)
                horizontalLineTo(19.0f)
                verticalLineToRelative(3.94f)
                curveToRelative(0.0f, 0.26f, 0.36f, 0.35f, 0.47f, 0.11f)
                lineToRelative(2.66f, -5.33f)
                curveTo(22.3f, 16.39f, 22.06f, 16.0f, 21.69f, 16.0f)
                close()
            }
        }
        return _quickreply!!
    }

private var _quickreply: ImageVector? = null
