/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.DirectionsOff: ImageVector
    get() {
        if (_directionsOff != null) {
            return _directionsOff!!
        }
        _directionsOff = materialIcon(name = "Sharp.DirectionsOff") {
            materialPath {
                moveTo(13.0f, 7.5f)
                lineToRelative(3.5f, 3.5f)
                lineToRelative(-1.33f, 1.34f)
                lineToRelative(3.45f, 3.45f)
                lineToRelative(3.79f, -3.79f)
                lineToRelative(-10.4f, -10.42f)
                lineToRelative(-3.8f, 3.8f)
                lineToRelative(4.79f, 4.79f)
                close()
            }
            materialPath {
                moveTo(1.39f, 4.22f)
                lineToRelative(3.99f, 3.99f)
                lineToRelative(-3.79f, 3.79f)
                lineTo(12.01f, 22.4f)
                lineToRelative(3.79f, -3.79f)
                lineToRelative(3.99f, 3.99f)
                lineToRelative(1.41f, -1.41f)
                lineTo(2.81f, 2.81f)
                lineTo(1.39f, 4.22f)
                close()
                moveTo(9.99f, 12.82f)
                verticalLineTo(15.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-4.18f)
                lineTo(9.99f, 12.82f)
                close()
            }
        }
        return _directionsOff!!
    }

private var _directionsOff: ImageVector? = null
