/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.LocalAirport: ImageVector
    get() {
        if (_localAirport != null) {
            return _localAirport!!
        }
        _localAirport = materialIcon(name = "Sharp.LocalAirport") {
            materialPath {
                moveTo(22.0f, 16.0f)
                verticalLineToRelative(-2.0f)
                lineToRelative(-8.5f, -5.0f)
                verticalLineTo(3.5f)
                curveTo(13.5f, 2.67f, 12.83f, 2.0f, 12.0f, 2.0f)
                reflectiveCurveToRelative(-1.5f, 0.67f, -1.5f, 1.5f)
                verticalLineTo(9.0f)
                lineTo(2.0f, 14.0f)
                verticalLineToRelative(2.0f)
                lineToRelative(8.5f, -2.5f)
                verticalLineTo(19.0f)
                lineTo(8.0f, 20.5f)
                lineTo(8.0f, 22.0f)
                lineToRelative(4.0f, -1.0f)
                lineToRelative(4.0f, 1.0f)
                lineToRelative(0.0f, -1.5f)
                lineTo(13.5f, 19.0f)
                verticalLineToRelative(-5.5f)
                lineTo(22.0f, 16.0f)
                close()
            }
        }
        return _localAirport!!
    }

private var _localAirport: ImageVector? = null
