/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.BedtimeOff: ImageVector
    get() {
        if (_bedtimeOff != null) {
            return _bedtimeOff!!
        }
        _bedtimeOff = materialIcon(name = "TwoTone.BedtimeOff") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(7.95f, 5.13f)
                lineTo(9.03f, 6.2f)
                curveToRelative(0.05f, -0.55f, 0.12f, -1.12f, 0.24f, -1.71f)
                curveTo(8.81f, 4.66f, 8.37f, 4.88f, 7.95f, 5.13f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(5.13f, 7.96f)
                curveTo(4.42f, 9.15f, 4.0f, 10.52f, 4.0f, 12.0f)
                curveToRelative(0.0f, 4.41f, 3.59f, 8.0f, 8.0f, 8.0f)
                curveToRelative(1.45f, 0.0f, 2.84f, -0.4f, 4.05f, -1.12f)
                lineTo(5.13f, 7.96f)
                close()
            }
            materialPath {
                moveTo(9.27f, 4.49f)
                curveTo(9.14f, 5.08f, 9.07f, 5.64f, 9.03f, 6.2f)
                lineToRelative(2.05f, 2.05f)
                curveToRelative(-0.27f, -2.05f, 0.1f, -4.22f, 1.26f, -6.23f)
                curveToRelative(-0.12f, 0.0f, -0.23f, -0.01f, -0.35f, -0.01f)
                curveToRelative(-2.05f, 0.0f, -3.93f, 0.61f, -5.5f, 1.65f)
                lineToRelative(1.46f, 1.46f)
                curveTo(8.37f, 4.88f, 8.81f, 4.66f, 9.27f, 4.49f)
                close()
            }
            materialPath {
                moveTo(2.81f, 2.81f)
                lineTo(1.39f, 4.22f)
                lineToRelative(2.27f, 2.27f)
                curveTo(2.61f, 8.07f, 2.0f, 9.97f, 2.0f, 12.0f)
                curveToRelative(0.0f, 5.52f, 4.48f, 10.0f, 10.0f, 10.0f)
                curveToRelative(2.04f, 0.0f, 3.92f, -0.63f, 5.5f, -1.67f)
                lineToRelative(2.28f, 2.28f)
                lineToRelative(1.41f, -1.41f)
                lineTo(2.81f, 2.81f)
                close()
                moveTo(12.0f, 20.0f)
                curveToRelative(-4.41f, 0.0f, -8.0f, -3.59f, -8.0f, -8.0f)
                curveToRelative(0.0f, -1.48f, 0.42f, -2.85f, 1.13f, -4.04f)
                lineToRelative(10.92f, 10.92f)
                curveTo(14.84f, 19.6f, 13.45f, 20.0f, 12.0f, 20.0f)
                close()
            }
        }
        return _bedtimeOff!!
    }

private var _bedtimeOff: ImageVector? = null
