/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.WbIridescent: ImageVector
    get() {
        if (_wbIridescent != null) {
            return _wbIridescent!!
        }
        _wbIridescent = materialIcon(name = "Filled.WbIridescent") {
            materialPath {
                moveTo(5.0f, 14.5f)
                horizontalLineToRelative(14.0f)
                verticalLineToRelative(-6.0f)
                lineTo(5.0f, 8.5f)
                verticalLineToRelative(6.0f)
                close()
                moveTo(11.0f, 0.55f)
                lineTo(11.0f, 3.5f)
                horizontalLineToRelative(2.0f)
                lineTo(13.0f, 0.55f)
                horizontalLineToRelative(-2.0f)
                close()
                moveTo(19.04f, 3.05f)
                lineToRelative(-1.79f, 1.79f)
                lineToRelative(1.41f, 1.41f)
                lineToRelative(1.8f, -1.79f)
                lineToRelative(-1.42f, -1.41f)
                close()
                moveTo(13.0f, 22.45f)
                lineTo(13.0f, 19.5f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(2.95f)
                horizontalLineToRelative(2.0f)
                close()
                moveTo(20.45f, 18.54f)
                lineToRelative(-1.8f, -1.79f)
                lineToRelative(-1.41f, 1.41f)
                lineToRelative(1.79f, 1.8f)
                lineToRelative(1.42f, -1.42f)
                close()
                moveTo(3.55f, 4.46f)
                lineToRelative(1.79f, 1.79f)
                lineToRelative(1.41f, -1.41f)
                lineToRelative(-1.79f, -1.79f)
                lineToRelative(-1.41f, 1.41f)
                close()
                moveTo(4.96f, 19.95f)
                lineToRelative(1.79f, -1.8f)
                lineToRelative(-1.41f, -1.41f)
                lineToRelative(-1.79f, 1.79f)
                lineToRelative(1.41f, 1.42f)
                close()
            }
        }
        return _wbIridescent!!
    }

private var _wbIridescent: ImageVector? = null
