/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded._1xMobiledata: ImageVector
    get() {
        if (__1xMobiledata != null) {
            return __1xMobiledata!!
        }
        __1xMobiledata = materialIcon(name = "Rounded._1xMobiledata") {
            materialPath {
                moveTo(5.0f, 7.0f)
                horizontalLineToRelative(2.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineToRelative(8.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                verticalLineTo(9.0f)
                horizontalLineTo(5.0f)
                curveTo(4.45f, 9.0f, 4.0f, 8.55f, 4.0f, 8.0f)
                verticalLineToRelative(0.0f)
                curveTo(4.0f, 7.45f, 4.45f, 7.0f, 5.0f, 7.0f)
                close()
                moveTo(15.83f, 11.72f)
                lineToRelative(1.92f, -3.21f)
                curveTo(18.15f, 7.85f, 17.67f, 7.0f, 16.9f, 7.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(-0.35f, 0.0f, -0.68f, 0.18f, -0.86f, 0.49f)
                lineToRelative(-1.37f, 2.28f)
                lineToRelative(-1.38f, -2.29f)
                curveTo(13.11f, 7.18f, 12.79f, 7.0f, 12.44f, 7.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(-0.78f, 0.0f, -1.26f, 0.85f, -0.86f, 1.51f)
                lineToRelative(1.92f, 3.21f)
                lineToRelative(-2.26f, 3.77f)
                curveToRelative(-0.4f, 0.67f, 0.08f, 1.51f, 0.86f, 1.51f)
                horizontalLineToRelative(0.0f)
                curveToRelative(0.35f, 0.0f, 0.68f, -0.18f, 0.86f, -0.49f)
                lineToRelative(1.71f, -2.85f)
                lineToRelative(1.71f, 2.85f)
                curveToRelative(0.18f, 0.3f, 0.51f, 0.49f, 0.86f, 0.49f)
                horizontalLineToRelative(0.01f)
                curveToRelative(0.78f, 0.0f, 1.26f, -0.85f, 0.86f, -1.51f)
                lineTo(15.83f, 11.72f)
                close()
            }
        }
        return __1xMobiledata!!
    }

private var __1xMobiledata: ImageVector? = null
