/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.TypeSpecimen: ImageVector
    get() {
        if (_typeSpecimen != null) {
            return _typeSpecimen!!
        }
        _typeSpecimen = materialIcon(name = "Sharp.TypeSpecimen") {
            materialPath {
                moveTo(4.0f, 6.0f)
                lineToRelative(-2.0f, 0.0f)
                lineToRelative(0.0f, 16.0f)
                lineToRelative(16.0f, 0.0f)
                lineToRelative(0.0f, -2.0f)
                lineToRelative(-14.0f, 0.0f)
                close()
            }
            materialPath {
                moveTo(22.0f, 2.0f)
                horizontalLineTo(6.0f)
                verticalLineToRelative(16.0f)
                horizontalLineToRelative(16.0f)
                verticalLineTo(2.0f)
                close()
                moveTo(16.63f, 14.5f)
                lineToRelative(-0.8f, -2.3f)
                horizontalLineToRelative(-3.63f)
                lineToRelative(-0.82f, 2.3f)
                horizontalLineTo(9.81f)
                lineToRelative(3.38f, -9.0f)
                horizontalLineToRelative(1.61f)
                lineToRelative(3.38f, 9.0f)
                horizontalLineTo(16.63f)
                close()
            }
            materialPath {
                moveTo(13.96f, 7.17f)
                lineToRelative(-1.31f, 3.72f)
                lineToRelative(2.69f, 0.0f)
                lineToRelative(-1.3f, -3.72f)
                close()
            }
        }
        return _typeSpecimen!!
    }

private var _typeSpecimen: ImageVector? = null
