/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.ForkLeft: ImageVector
    get() {
        if (_forkLeft != null) {
            return _forkLeft!!
        }
        _forkLeft = materialIcon(name = "TwoTone.ForkLeft") {
            materialPath {
                moveTo(9.41f, 15.59f)
                lineTo(8.0f, 17.0f)
                lineToRelative(-4.0f, -4.0f)
                lineToRelative(4.0f, -4.0f)
                lineToRelative(1.41f, 1.41f)
                lineTo(7.83f, 12.0f)
                curveToRelative(1.51f, -0.33f, 3.73f, 0.08f, 5.17f, 1.36f)
                lineToRelative(0.0f, -6.53f)
                lineToRelative(-1.59f, 1.59f)
                lineTo(10.0f, 7.0f)
                lineToRelative(4.0f, -4.0f)
                lineToRelative(4.0f, 4.0f)
                lineToRelative(-1.41f, 1.41f)
                lineTo(15.0f, 6.83f)
                verticalLineTo(21.0f)
                lineToRelative(-2.0f, 0.0f)
                verticalLineToRelative(-4.0f)
                curveToRelative(-0.73f, -2.58f, -3.07f, -3.47f, -5.17f, -3.0f)
                lineTo(9.41f, 15.59f)
                close()
            }
        }
        return _forkLeft!!
    }

private var _forkLeft: ImageVector? = null
