/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.MarkUnreadChatAlt: ImageVector
    get() {
        if (_markUnreadChatAlt != null) {
            return _markUnreadChatAlt!!
        }
        _markUnreadChatAlt = materialIcon(name = "TwoTone.MarkUnreadChatAlt") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(4.0f, 17.17f)
                lineTo(5.17f, 16.0f)
                horizontalLineTo(20.0f)
                verticalLineTo(7.9f)
                curveTo(19.68f, 7.96f, 19.34f, 8.0f, 19.0f, 8.0f)
                reflectiveCurveToRelative(-0.68f, -0.04f, -1.0f, -0.1f)
                verticalLineTo(8.0f)
                horizontalLineTo(6.0f)
                verticalLineTo(6.0f)
                horizontalLineToRelative(9.03f)
                curveToRelative(-0.44f, -0.58f, -0.77f, -1.26f, -0.92f, -2.0f)
                horizontalLineTo(4.0f)
                verticalLineTo(17.17f)
                close()
                moveTo(6.0f, 9.0f)
                horizontalLineToRelative(12.0f)
                verticalLineToRelative(2.0f)
                horizontalLineTo(6.0f)
                verticalLineTo(9.0f)
                close()
                moveTo(6.0f, 12.0f)
                horizontalLineToRelative(8.0f)
                verticalLineToRelative(2.0f)
                horizontalLineTo(6.0f)
                verticalLineTo(12.0f)
                close()
            }
            materialPath {
                moveTo(19.0f, 3.0f)
                moveToRelative(-3.0f, 0.0f)
                arcToRelative(3.0f, 3.0f, 0.0f, true, true, 6.0f, 0.0f)
                arcToRelative(3.0f, 3.0f, 0.0f, true, true, -6.0f, 0.0f)
            }
            materialPath {
                moveTo(20.0f, 16.0f)
                horizontalLineTo(5.17f)
                lineTo(4.0f, 17.17f)
                verticalLineTo(4.0f)
                horizontalLineToRelative(10.1f)
                curveToRelative(-0.18f, -0.89f, -0.08f, -1.61f, 0.0f, -2.0f)
                horizontalLineTo(4.0f)
                curveTo(2.9f, 2.0f, 2.01f, 2.9f, 2.01f, 4.0f)
                lineTo(2.0f, 22.0f)
                lineToRelative(4.0f, -4.0f)
                horizontalLineToRelative(14.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(6.97f)
                curveToRelative(-0.58f, 0.44f, -1.26f, 0.77f, -2.0f, 0.92f)
                verticalLineTo(16.0f)
                close()
            }
            materialPath {
                moveTo(6.0f, 12.0f)
                horizontalLineToRelative(8.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-8.0f)
                close()
            }
            materialPath {
                moveTo(6.0f, 9.0f)
                horizontalLineToRelative(12.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-12.0f)
                close()
            }
            materialPath {
                moveTo(6.0f, 8.0f)
                horizontalLineToRelative(12.0f)
                verticalLineTo(7.9f)
                curveToRelative(-1.21f, -0.25f, -2.25f, -0.95f, -2.97f, -1.9f)
                horizontalLineTo(6.0f)
                verticalLineTo(8.0f)
                close()
            }
        }
        return _markUnreadChatAlt!!
    }

private var _markUnreadChatAlt: ImageVector? = null
