/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.AdfScanner: ImageVector
    get() {
        if (_adfScanner != null) {
            return _adfScanner!!
        }
        _adfScanner = materialIcon(name = "Outlined.AdfScanner") {
            materialPath {
                moveTo(19.0f, 12.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineTo(4.0f)
                horizontalLineTo(6.0f)
                verticalLineToRelative(8.0f)
                horizontalLineTo(5.0f)
                curveToRelative(-1.66f, 0.0f, -3.0f, 1.34f, -3.0f, 3.0f)
                verticalLineToRelative(5.0f)
                horizontalLineToRelative(20.0f)
                verticalLineToRelative(-5.0f)
                curveTo(22.0f, 13.34f, 20.66f, 12.0f, 19.0f, 12.0f)
                close()
                moveTo(8.0f, 6.0f)
                horizontalLineToRelative(8.0f)
                verticalLineToRelative(6.0f)
                horizontalLineTo(8.0f)
                verticalLineTo(6.0f)
                close()
                moveTo(20.0f, 18.0f)
                horizontalLineTo(4.0f)
                verticalLineToRelative(-3.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                horizontalLineToRelative(14.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineTo(18.0f)
                close()
            }
            materialPath {
                moveTo(18.0f, 16.0f)
                moveToRelative(-1.0f, 0.0f)
                arcToRelative(1.0f, 1.0f, 0.0f, true, true, 2.0f, 0.0f)
                arcToRelative(1.0f, 1.0f, 0.0f, true, true, -2.0f, 0.0f)
            }
        }
        return _adfScanner!!
    }

private var _adfScanner: ImageVector? = null
