/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.Church: ImageVector
    get() {
        if (_church != null) {
            return _church!!
        }
        _church = materialIcon(name = "Outlined.Church") {
            materialPath {
                moveTo(18.0f, 12.22f)
                verticalLineTo(9.0f)
                lineToRelative(-5.0f, -2.5f)
                verticalLineTo(5.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(3.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineTo(1.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineTo(9.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(1.5f)
                lineTo(6.0f, 9.0f)
                verticalLineToRelative(3.22f)
                lineTo(2.0f, 14.0f)
                verticalLineToRelative(8.0f)
                horizontalLineToRelative(9.0f)
                verticalLineToRelative(-4.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(9.0f)
                verticalLineToRelative(-8.0f)
                lineTo(18.0f, 12.22f)
                close()
                moveTo(20.0f, 20.0f)
                horizontalLineToRelative(-5.0f)
                verticalLineToRelative(-2.04f)
                curveToRelative(0.0f, -1.69f, -1.35f, -3.06f, -3.0f, -3.06f)
                curveToRelative(-1.65f, 0.0f, -3.0f, 1.37f, -3.0f, 3.06f)
                verticalLineTo(20.0f)
                horizontalLineTo(4.0f)
                verticalLineToRelative(-4.79f)
                lineToRelative(4.0f, -1.81f)
                verticalLineToRelative(-3.35f)
                lineTo(12.0f, 8.0f)
                lineToRelative(4.0f, 2.04f)
                verticalLineToRelative(3.35f)
                lineToRelative(4.0f, 1.81f)
                verticalLineTo(20.0f)
                close()
            }
            materialPath {
                moveTo(12.0f, 12.0f)
                moveToRelative(-1.5f, 0.0f)
                arcToRelative(1.5f, 1.5f, 0.0f, true, true, 3.0f, 0.0f)
                arcToRelative(1.5f, 1.5f, 0.0f, true, true, -3.0f, 0.0f)
            }
        }
        return _church!!
    }

private var _church: ImageVector? = null
