/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Airlines: ImageVector
    get() {
        if (_airlines != null) {
            return _airlines!!
        }
        _airlines = materialIcon(name = "Rounded.Airlines") {
            materialPath {
                moveTo(19.59f, 4.0f)
                horizontalLineToRelative(-5.01f)
                curveToRelative(-0.99f, 0.0f, -1.91f, 0.49f, -2.47f, 1.3f)
                lineTo(2.0f, 20.0f)
                horizontalLineToRelative(17.0f)
                lineToRelative(2.56f, -13.63f)
                curveTo(21.79f, 5.14f, 20.84f, 4.0f, 19.59f, 4.0f)
                close()
                moveTo(14.5f, 14.0f)
                curveToRelative(-1.38f, 0.0f, -2.5f, -1.12f, -2.5f, -2.5f)
                curveToRelative(0.0f, -1.38f, 1.12f, -2.5f, 2.5f, -2.5f)
                reflectiveCurveToRelative(2.5f, 1.12f, 2.5f, 2.5f)
                curveTo(17.0f, 12.88f, 15.88f, 14.0f, 14.5f, 14.0f)
                close()
            }
        }
        return _airlines!!
    }

private var _airlines: ImageVector? = null
