/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.FrontHand: ImageVector
    get() {
        if (_frontHand != null) {
            return _frontHand!!
        }
        _frontHand = materialIcon(name = "Sharp.FrontHand") {
            materialPath {
                moveTo(18.5f, 8.0f)
                verticalLineToRelative(7.0f)
                horizontalLineTo(18.0f)
                curveToRelative(-1.65f, 0.0f, -3.0f, 1.35f, -3.0f, 3.0f)
                horizontalLineToRelative(-1.0f)
                curveToRelative(0.0f, -2.04f, 1.53f, -3.72f, 3.5f, -3.97f)
                verticalLineTo(2.0f)
                horizontalLineTo(15.0f)
                verticalLineToRelative(9.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineTo(0.0f)
                horizontalLineToRelative(-2.5f)
                verticalLineToRelative(11.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineTo(1.5f)
                horizontalLineTo(8.0f)
                verticalLineTo(12.0f)
                horizontalLineTo(7.0f)
                verticalLineTo(4.5f)
                horizontalLineTo(4.5f)
                verticalLineToRelative(11.25f)
                curveToRelative(0.0f, 4.56f, 3.69f, 8.25f, 8.25f, 8.25f)
                reflectiveCurveTo(21.0f, 20.31f, 21.0f, 15.75f)
                verticalLineTo(8.0f)
                horizontalLineTo(18.5f)
                close()
            }
        }
        return _frontHand!!
    }

private var _frontHand: ImageVector? = null
