/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.PhoneBluetoothSpeaker: ImageVector
    get() {
        if (_phoneBluetoothSpeaker != null) {
            return _phoneBluetoothSpeaker!!
        }
        _phoneBluetoothSpeaker = materialIcon(name = "Sharp.PhoneBluetoothSpeaker") {
            materialPath {
                moveTo(14.71f, 9.5f)
                lineTo(17.0f, 7.21f)
                lineTo(17.0f, 11.0f)
                horizontalLineToRelative(0.5f)
                lineToRelative(2.85f, -2.85f)
                lineTo(18.21f, 6.0f)
                lineToRelative(2.15f, -2.15f)
                lineTo(17.5f, 1.0f)
                lineTo(17.0f, 1.0f)
                verticalLineToRelative(3.79f)
                lineTo(14.71f, 2.5f)
                lineToRelative(-0.71f, 0.71f)
                lineTo(16.79f, 6.0f)
                lineTo(14.0f, 8.79f)
                lineToRelative(0.71f, 0.71f)
                close()
                moveTo(18.0f, 2.91f)
                lineToRelative(0.94f, 0.94f)
                lineToRelative(-0.94f, 0.94f)
                lineTo(18.0f, 2.91f)
                close()
                moveTo(18.0f, 7.21f)
                lineToRelative(0.94f, 0.94f)
                lineToRelative(-0.94f, 0.94f)
                lineTo(18.0f, 7.21f)
                close()
                moveTo(21.0f, 15.46f)
                lineToRelative(-5.27f, -0.61f)
                lineToRelative(-2.52f, 2.52f)
                curveToRelative(-2.83f, -1.44f, -5.15f, -3.75f, -6.59f, -6.59f)
                lineToRelative(2.53f, -2.53f)
                lineTo(8.54f, 3.0f)
                lineTo(3.03f, 3.0f)
                curveTo(2.45f, 13.18f, 10.82f, 21.55f, 21.0f, 20.97f)
                verticalLineToRelative(-5.51f)
                close()
            }
        }
        return _phoneBluetoothSpeaker!!
    }

private var _phoneBluetoothSpeaker: ImageVector? = null
