/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.SetMeal: ImageVector
    get() {
        if (_setMeal != null) {
            return _setMeal!!
        }
        _setMeal = materialIcon(name = "Sharp.SetMeal") {
            materialPath {
                moveTo(21.05f, 17.56f)
                lineTo(3.08f, 18.5f)
                lineTo(3.0f, 17.0f)
                lineToRelative(17.98f, -0.94f)
                lineTo(21.05f, 17.56f)
                close()
                moveTo(21.0f, 19.48f)
                horizontalLineTo(3.0f)
                verticalLineToRelative(1.5f)
                horizontalLineToRelative(18.0f)
                verticalLineTo(19.48f)
                close()
                moveTo(22.0f, 3.0f)
                verticalLineToRelative(11.0f)
                horizontalLineTo(2.0f)
                verticalLineTo(3.0f)
                horizontalLineTo(22.0f)
                close()
                moveTo(20.0f, 6.0f)
                curveToRelative(-1.68f, 0.0f, -3.04f, 0.98f, -3.21f, 2.23f)
                curveTo(16.15f, 7.5f, 14.06f, 5.5f, 10.25f, 5.5f)
                curveToRelative(-4.67f, 0.0f, -6.75f, 3.0f, -6.75f, 3.0f)
                reflectiveCurveToRelative(2.08f, 3.0f, 6.75f, 3.0f)
                curveToRelative(3.81f, 0.0f, 5.9f, -2.0f, 6.54f, -2.73f)
                curveTo(16.96f, 10.02f, 18.32f, 11.0f, 20.0f, 11.0f)
                verticalLineTo(6.0f)
                close()
            }
        }
        return _setMeal!!
    }

private var _setMeal: ImageVector? = null
