/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.Rotate90DegreesCw: ImageVector
    get() {
        if (_rotate90DegreesCw != null) {
            return _rotate90DegreesCw!!
        }
        _rotate90DegreesCw = materialIcon(name = "TwoTone.Rotate90DegreesCw") {
            materialPath {
                moveTo(4.64f, 19.37f)
                curveToRelative(3.03f, 3.03f, 7.67f, 3.44f, 11.15f, 1.25f)
                lineToRelative(-1.46f, -1.46f)
                curveToRelative(-2.66f, 1.43f, -6.04f, 1.03f, -8.28f, -1.21f)
                curveToRelative(-2.73f, -2.73f, -2.73f, -7.17f, 0.0f, -9.9f)
                curveTo(7.42f, 6.69f, 9.21f, 6.03f, 11.0f, 6.03f)
                verticalLineTo(9.0f)
                lineToRelative(4.0f, -4.0f)
                lineToRelative(-4.0f, -4.0f)
                verticalLineToRelative(3.01f)
                curveToRelative(-2.3f, 0.0f, -4.61f, 0.87f, -6.36f, 2.63f)
                curveTo(1.12f, 10.15f, 1.12f, 15.85f, 4.64f, 19.37f)
                close()
                moveTo(11.0f, 13.0f)
                lineToRelative(6.0f, 6.0f)
                lineToRelative(6.0f, -6.0f)
                lineToRelative(-6.0f, -6.0f)
                lineTo(11.0f, 13.0f)
                close()
                moveTo(17.0f, 16.17f)
                lineTo(13.83f, 13.0f)
                lineTo(17.0f, 9.83f)
                lineTo(20.17f, 13.0f)
                lineTo(17.0f, 16.17f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(13.817f, 12.995f)
                lineToRelative(3.175f, -3.175f)
                lineToRelative(3.175f, 3.175f)
                lineToRelative(-3.175f, 3.175f)
                close()
            }
        }
        return _rotate90DegreesCw!!
    }

private var _rotate90DegreesCw: ImageVector? = null
