/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.Fax: ImageVector
    get() {
        if (_fax != null) {
            return _fax!!
        }
        _fax = materialIcon(name = "Filled.Fax") {
            materialPath {
                moveTo(19.0f, 9.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineTo(4.0f)
                horizontalLineTo(8.0f)
                verticalLineToRelative(14.5f)
                verticalLineTo(20.0f)
                horizontalLineToRelative(14.0f)
                verticalLineToRelative(-8.0f)
                curveTo(22.0f, 10.34f, 20.66f, 9.0f, 19.0f, 9.0f)
                close()
                moveTo(10.0f, 6.0f)
                horizontalLineToRelative(6.0f)
                verticalLineToRelative(3.0f)
                horizontalLineToRelative(-6.0f)
                verticalLineTo(6.0f)
                close()
                moveTo(14.0f, 17.0f)
                horizontalLineToRelative(-4.0f)
                verticalLineToRelative(-5.0f)
                horizontalLineToRelative(4.0f)
                verticalLineTo(17.0f)
                close()
                moveTo(16.0f, 17.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                curveTo(17.0f, 16.55f, 16.55f, 17.0f, 16.0f, 17.0f)
                close()
                moveTo(16.0f, 14.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                curveTo(17.0f, 13.55f, 16.55f, 14.0f, 16.0f, 14.0f)
                close()
                moveTo(19.0f, 17.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                curveTo(20.0f, 16.55f, 19.55f, 17.0f, 19.0f, 17.0f)
                close()
                moveTo(19.0f, 14.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                curveTo(20.0f, 13.55f, 19.55f, 14.0f, 19.0f, 14.0f)
                close()
            }
            materialPath {
                moveTo(4.5f, 8.0f)
                curveTo(3.12f, 8.0f, 2.0f, 9.12f, 2.0f, 10.5f)
                verticalLineToRelative(8.0f)
                curveTo(2.0f, 19.88f, 3.12f, 21.0f, 4.5f, 21.0f)
                reflectiveCurveTo(7.0f, 19.88f, 7.0f, 18.5f)
                verticalLineToRelative(-8.0f)
                curveTo(7.0f, 9.12f, 5.88f, 8.0f, 4.5f, 8.0f)
                close()
            }
        }
        return _fax!!
    }

private var _fax: ImageVector? = null
