/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.Groups2: ImageVector
    get() {
        if (_groups2 != null) {
            return _groups2!!
        }
        _groups2 = materialIcon(name = "Sharp.Groups2") {
            materialPath {
                moveTo(10.27f, 12.0f)
                horizontalLineToRelative(3.46f)
                curveToRelative(0.93f, 0.0f, 1.63f, -0.83f, 1.48f, -1.75f)
                lineToRelative(-0.3f, -1.79f)
                curveTo(14.67f, 7.04f, 13.44f, 6.0f, 12.0f, 6.0f)
                reflectiveCurveTo(9.33f, 7.04f, 9.09f, 8.47f)
                lineToRelative(-0.3f, 1.79f)
                curveTo(8.64f, 11.17f, 9.34f, 12.0f, 10.27f, 12.0f)
                close()
            }
            materialPath {
                moveTo(1.66f, 11.11f)
                curveToRelative(-0.13f, 0.26f, -0.18f, 0.57f, -0.1f, 0.88f)
                curveToRelative(0.16f, 0.69f, 0.76f, 1.03f, 1.53f, 1.0f)
                curveToRelative(0.0f, 0.0f, 1.49f, 0.0f, 1.95f, 0.0f)
                curveToRelative(0.83f, 0.0f, 1.51f, -0.58f, 1.51f, -1.29f)
                curveToRelative(0.0f, -0.14f, -0.03f, -0.27f, -0.07f, -0.4f)
                curveToRelative(-0.01f, -0.03f, -0.01f, -0.05f, 0.01f, -0.08f)
                curveToRelative(0.09f, -0.16f, 0.14f, -0.34f, 0.14f, -0.53f)
                curveToRelative(0.0f, -0.31f, -0.14f, -0.6f, -0.36f, -0.82f)
                curveToRelative(-0.03f, -0.03f, -0.03f, -0.06f, -0.02f, -0.1f)
                curveToRelative(0.07f, -0.2f, 0.07f, -0.43f, 0.01f, -0.65f)
                curveTo(6.1f, 8.69f, 5.71f, 8.4f, 5.27f, 8.38f)
                curveToRelative(-0.03f, 0.0f, -0.05f, -0.01f, -0.07f, -0.03f)
                curveTo(5.03f, 8.14f, 4.72f, 8.0f, 4.37f, 8.0f)
                curveTo(4.07f, 8.0f, 3.8f, 8.1f, 3.62f, 8.26f)
                curveTo(3.59f, 8.29f, 3.56f, 8.29f, 3.53f, 8.28f)
                curveToRelative(-0.14f, -0.06f, -0.3f, -0.09f, -0.46f, -0.09f)
                curveToRelative(-0.65f, 0.0f, -1.18f, 0.49f, -1.24f, 1.12f)
                curveToRelative(0.0f, 0.02f, -0.01f, 0.04f, -0.03f, 0.06f)
                curveToRelative(-0.29f, 0.26f, -0.46f, 0.65f, -0.41f, 1.05f)
                curveToRelative(0.03f, 0.22f, 0.12f, 0.43f, 0.25f, 0.6f)
                curveTo(1.67f, 11.04f, 1.67f, 11.08f, 1.66f, 11.11f)
                close()
            }
            materialPath {
                moveTo(16.24f, 13.65f)
                curveToRelative(-1.17f, -0.52f, -2.61f, -0.9f, -4.24f, -0.9f)
                curveToRelative(-1.63f, 0.0f, -3.07f, 0.39f, -4.24f, 0.9f)
                curveTo(6.68f, 14.13f, 6.0f, 15.21f, 6.0f, 16.39f)
                verticalLineTo(18.0f)
                horizontalLineToRelative(12.0f)
                verticalLineToRelative(-1.61f)
                curveTo(18.0f, 15.21f, 17.32f, 14.13f, 16.24f, 13.65f)
                close()
            }
            materialPath {
                moveTo(1.22f, 14.58f)
                curveTo(0.48f, 14.9f, 0.0f, 15.62f, 0.0f, 16.43f)
                verticalLineTo(18.0f)
                lineToRelative(4.5f, 0.0f)
                verticalLineToRelative(-1.61f)
                curveToRelative(0.0f, -0.83f, 0.23f, -1.61f, 0.63f, -2.29f)
                curveTo(4.76f, 14.04f, 4.39f, 14.0f, 4.0f, 14.0f)
                curveTo(3.01f, 14.0f, 2.07f, 14.21f, 1.22f, 14.58f)
                close()
            }
            materialPath {
                moveTo(22.78f, 14.58f)
                curveTo(21.93f, 14.21f, 20.99f, 14.0f, 20.0f, 14.0f)
                curveToRelative(-0.39f, 0.0f, -0.76f, 0.04f, -1.13f, 0.1f)
                curveToRelative(0.4f, 0.68f, 0.63f, 1.46f, 0.63f, 2.29f)
                verticalLineTo(18.0f)
                lineToRelative(4.5f, 0.0f)
                verticalLineToRelative(-1.57f)
                curveTo(24.0f, 15.62f, 23.52f, 14.9f, 22.78f, 14.58f)
                close()
            }
            materialPath {
                moveTo(22.0f, 11.0f)
                verticalLineToRelative(-0.5f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                horizontalLineToRelative(-2.0f)
                curveToRelative(-0.42f, 0.0f, -0.65f, 0.48f, -0.39f, 0.81f)
                lineToRelative(0.7f, 0.63f)
                curveTo(18.12f, 10.25f, 18.0f, 10.61f, 18.0f, 11.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                reflectiveCurveTo(22.0f, 12.1f, 22.0f, 11.0f)
                close()
            }
        }
        return _groups2!!
    }

private var _groups2: ImageVector? = null
