/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.EditNotifications: ImageVector
    get() {
        if (_editNotifications != null) {
            return _editNotifications!!
        }
        _editNotifications = materialIcon(name = "Filled.EditNotifications") {
            materialPath {
                moveTo(17.58f, 6.25f)
                lineToRelative(1.77f, 1.77f)
                lineTo(14.37f, 13.0f)
                horizontalLineTo(12.6f)
                verticalLineToRelative(-1.77f)
                lineTo(17.58f, 6.25f)
                close()
                moveTo(20.85f, 5.81f)
                lineToRelative(-1.06f, -1.06f)
                curveToRelative(-0.2f, -0.2f, -0.51f, -0.2f, -0.71f, 0.0f)
                lineToRelative(-0.85f, 0.85f)
                lineToRelative(1.77f, 1.77f)
                lineToRelative(0.85f, -0.85f)
                curveTo(21.05f, 6.32f, 21.05f, 6.0f, 20.85f, 5.81f)
                close()
                moveTo(18.0f, 12.2f)
                verticalLineTo(17.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineTo(4.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-7.0f)
                curveToRelative(0.0f, -2.79f, 1.91f, -5.14f, 4.5f, -5.8f)
                verticalLineTo(3.5f)
                curveTo(10.5f, 2.67f, 11.17f, 2.0f, 12.0f, 2.0f)
                reflectiveCurveToRelative(1.5f, 0.67f, 1.5f, 1.5f)
                verticalLineToRelative(0.7f)
                curveToRelative(0.82f, 0.21f, 1.57f, 0.59f, 2.21f, 1.09f)
                lineTo(10.6f, 10.4f)
                verticalLineTo(15.0f)
                horizontalLineToRelative(4.6f)
                lineTo(18.0f, 12.2f)
                close()
                moveTo(10.0f, 20.0f)
                horizontalLineToRelative(4.0f)
                curveToRelative(0.0f, 1.1f, -0.9f, 2.0f, -2.0f, 2.0f)
                reflectiveCurveTo(10.0f, 21.1f, 10.0f, 20.0f)
                close()
            }
        }
        return _editNotifications!!
    }

private var _editNotifications: ImageVector? = null
