/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.RemoveDone: ImageVector
    get() {
        if (_removeDone != null) {
            return _removeDone!!
        }
        _removeDone = materialIcon(name = "Filled.RemoveDone") {
            materialPath {
                moveTo(1.79f, 12.0f)
                lineToRelative(5.58f, 5.59f)
                lineTo(5.96f, 19.0f)
                lineTo(0.37f, 13.41f)
                lineTo(1.79f, 12.0f)
                close()
                moveTo(2.24f, 4.22f)
                lineTo(12.9f, 14.89f)
                lineToRelative(-1.28f, 1.28f)
                lineTo(7.44f, 12.0f)
                lineToRelative(-1.41f, 1.41f)
                lineTo(11.62f, 19.0f)
                lineToRelative(2.69f, -2.69f)
                lineToRelative(4.89f, 4.89f)
                lineToRelative(1.41f, -1.41f)
                lineTo(3.65f, 2.81f)
                lineTo(2.24f, 4.22f)
                close()
                moveTo(17.14f, 13.49f)
                lineTo(23.62f, 7.0f)
                lineTo(22.2f, 5.59f)
                lineToRelative(-6.48f, 6.48f)
                lineToRelative(1.42f, 1.42f)
                close()
                moveTo(17.96f, 7.0f)
                lineToRelative(-1.41f, -1.41f)
                lineToRelative(-3.65f, 3.66f)
                lineToRelative(1.41f, 1.41f)
                lineTo(17.96f, 7.0f)
                close()
            }
        }
        return _removeDone!!
    }

private var _removeDone: ImageVector? = null
