/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.SportsMma: ImageVector
    get() {
        if (_sportsMma != null) {
            return _sportsMma!!
        }
        _sportsMma = materialIcon(name = "Filled.SportsMma") {
            materialPath {
                moveTo(7.0f, 20.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(8.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(-3.0f)
                horizontalLineTo(7.0f)
                verticalLineTo(20.0f)
                close()
            }
            materialPath {
                moveTo(18.0f, 7.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineTo(5.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                horizontalLineTo(7.0f)
                curveTo(5.9f, 3.0f, 5.0f, 3.9f, 5.0f, 5.0f)
                verticalLineToRelative(5.8f)
                curveToRelative(0.0f, 0.13f, 0.01f, 0.26f, 0.04f, 0.39f)
                lineToRelative(0.8f, 4.0f)
                curveToRelative(0.09f, 0.47f, 0.5f, 0.8f, 0.98f, 0.8f)
                horizontalLineToRelative(10.36f)
                curveToRelative(0.45f, 0.0f, 0.89f, -0.36f, 0.98f, -0.8f)
                lineToRelative(0.8f, -4.0f)
                curveTo(18.99f, 11.06f, 19.0f, 10.93f, 19.0f, 10.8f)
                verticalLineTo(8.0f)
                curveTo(19.0f, 7.45f, 18.55f, 7.0f, 18.0f, 7.0f)
                close()
                moveTo(15.0f, 10.0f)
                horizontalLineTo(7.0f)
                verticalLineTo(7.0f)
                horizontalLineToRelative(8.0f)
                verticalLineTo(10.0f)
                close()
            }
        }
        return _sportsMma!!
    }

private var _sportsMma: ImageVector? = null
