/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.TextRotationAngledown: ImageVector
    get() {
        if (_textRotationAngledown != null) {
            return _textRotationAngledown!!
        }
        _textRotationAngledown = materialIcon(name = "Filled.TextRotationAngledown") {
            materialPath {
                moveTo(19.4f, 4.91f)
                lineToRelative(-1.06f, -1.06f)
                lineTo(7.2f, 8.27f)
                lineToRelative(1.48f, 1.48f)
                lineToRelative(2.19f, -0.92f)
                lineToRelative(3.54f, 3.54f)
                lineToRelative(-0.92f, 2.19f)
                lineToRelative(1.48f, 1.48f)
                lineTo(19.4f, 4.91f)
                close()
                moveTo(12.59f, 8.01f)
                lineToRelative(4.87f, -2.23f)
                lineToRelative(-2.23f, 4.87f)
                lineToRelative(-2.64f, -2.64f)
                close()
                moveTo(14.27f, 21.0f)
                verticalLineToRelative(-4.24f)
                lineToRelative(-1.41f, 1.41f)
                lineToRelative(-8.84f, -8.84f)
                lineToRelative(-1.42f, 1.42f)
                lineToRelative(8.84f, 8.84f)
                lineTo(10.03f, 21.0f)
                horizontalLineToRelative(4.24f)
                close()
            }
        }
        return _textRotationAngledown!!
    }

private var _textRotationAngledown: ImageVector? = null
