/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.TimerOff: ImageVector
    get() {
        if (_timerOff != null) {
            return _timerOff!!
        }
        _timerOff = materialIcon(name = "Filled.TimerOff") {
            materialPath {
                moveTo(19.04f, 4.55f)
                lineToRelative(-1.42f, 1.42f)
                curveTo(16.07f, 4.74f, 14.12f, 4.0f, 12.0f, 4.0f)
                curveToRelative(-1.83f, 0.0f, -3.53f, 0.55f, -4.95f, 1.48f)
                lineToRelative(1.46f, 1.46f)
                curveTo(9.53f, 6.35f, 10.73f, 6.0f, 12.0f, 6.0f)
                curveToRelative(3.87f, 0.0f, 7.0f, 3.13f, 7.0f, 7.0f)
                curveToRelative(0.0f, 1.27f, -0.35f, 2.47f, -0.94f, 3.49f)
                lineToRelative(1.45f, 1.45f)
                curveTo(20.45f, 16.53f, 21.0f, 14.83f, 21.0f, 13.0f)
                curveToRelative(0.0f, -2.12f, -0.74f, -4.07f, -1.97f, -5.61f)
                lineToRelative(1.42f, -1.42f)
                lineToRelative(-1.41f, -1.42f)
                close()
                moveTo(15.0f, 1.0f)
                lineTo(9.0f, 1.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(6.0f)
                lineTo(15.0f, 1.0f)
                close()
                moveTo(11.0f, 9.44f)
                lineToRelative(2.0f, 2.0f)
                lineTo(13.0f, 8.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(1.44f)
                close()
                moveTo(3.02f, 4.0f)
                lineTo(1.75f, 5.27f)
                lineTo(4.5f, 8.03f)
                curveTo(3.55f, 9.45f, 3.0f, 11.16f, 3.0f, 13.0f)
                curveToRelative(0.0f, 4.97f, 4.02f, 9.0f, 9.0f, 9.0f)
                curveToRelative(1.84f, 0.0f, 3.55f, -0.55f, 4.98f, -1.5f)
                lineToRelative(2.5f, 2.5f)
                lineToRelative(1.27f, -1.27f)
                lineToRelative(-7.71f, -7.71f)
                lineTo(3.02f, 4.0f)
                close()
                moveTo(12.0f, 20.0f)
                curveToRelative(-3.87f, 0.0f, -7.0f, -3.13f, -7.0f, -7.0f)
                curveToRelative(0.0f, -1.28f, 0.35f, -2.48f, 0.95f, -3.52f)
                lineToRelative(9.56f, 9.56f)
                curveToRelative(-1.03f, 0.61f, -2.23f, 0.96f, -3.51f, 0.96f)
                close()
            }
        }
        return _timerOff!!
    }

private var _timerOff: ImageVector? = null
