/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.BedroomChild: ImageVector
    get() {
        if (_bedroomChild != null) {
            return _bedroomChild!!
        }
        _bedroomChild = materialIcon(name = "Outlined.BedroomChild") {
            materialPath {
                moveTo(20.0f, 4.0f)
                verticalLineToRelative(16.0f)
                horizontalLineTo(4.0f)
                verticalLineTo(4.0f)
                horizontalLineTo(20.0f)
                moveTo(20.0f, 2.0f)
                horizontalLineTo(4.0f)
                curveTo(2.9f, 2.0f, 2.0f, 2.9f, 2.0f, 4.0f)
                verticalLineToRelative(16.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(16.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(4.0f)
                curveTo(22.0f, 2.9f, 21.1f, 2.0f, 20.0f, 2.0f)
                close()
                moveTo(16.5f, 10.67f)
                verticalLineTo(9.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                horizontalLineToRelative(-5.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(1.67f)
                curveToRelative(-0.88f, 0.35f, -1.5f, 1.2f, -1.5f, 2.2f)
                verticalLineTo(17.0f)
                horizontalLineToRelative(1.5f)
                verticalLineToRelative(-1.5f)
                horizontalLineToRelative(9.0f)
                verticalLineTo(17.0f)
                horizontalLineTo(18.0f)
                verticalLineToRelative(-4.13f)
                curveTo(18.0f, 11.87f, 17.38f, 11.02f, 16.5f, 10.67f)
                close()
                moveTo(15.0f, 8.5f)
                verticalLineToRelative(2.0f)
                horizontalLineTo(9.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineTo(15.0f)
                close()
                moveTo(7.5f, 12.87f)
                curveTo(7.5f, 12.39f, 7.89f, 12.0f, 8.37f, 12.0f)
                horizontalLineToRelative(7.27f)
                curveToRelative(0.48f, 0.0f, 0.87f, 0.39f, 0.87f, 0.87f)
                verticalLineTo(14.0f)
                horizontalLineToRelative(-9.0f)
                verticalLineToRelative(-1.13f)
                horizontalLineTo(7.5f)
                close()
            }
        }
        return _bedroomChild!!
    }

private var _bedroomChild: ImageVector? = null
