/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.PanoramaPhotosphereSelect: ImageVector
    get() {
        if (_panoramaPhotosphereSelect != null) {
            return _panoramaPhotosphereSelect!!
        }
        _panoramaPhotosphereSelect = materialIcon(name = "Outlined.PanoramaPhotosphereSelect") {
            materialPath {
                moveTo(21.95f, 8.15f)
                curveToRelative(-0.29f, -0.16f, -0.61f, -0.31f, -0.93f, -0.46f)
                curveTo(19.4f, 4.33f, 15.98f, 2.0f, 12.0f, 2.0f)
                curveTo(8.02f, 2.0f, 4.6f, 4.33f, 2.99f, 7.68f)
                curveToRelative(-0.33f, 0.15f, -0.64f, 0.3f, -0.93f, 0.46f)
                curveTo(1.41f, 8.5f, 1.0f, 9.17f, 1.0f, 9.91f)
                verticalLineToRelative(4.18f)
                curveToRelative(0.0f, 0.74f, 0.41f, 1.41f, 1.05f, 1.77f)
                curveToRelative(0.29f, 0.16f, 0.61f, 0.31f, 0.93f, 0.46f)
                curveTo(4.6f, 19.67f, 8.02f, 22.0f, 12.0f, 22.0f)
                curveToRelative(3.98f, 0.0f, 7.4f, -2.33f, 9.01f, -5.68f)
                curveToRelative(0.33f, -0.15f, 0.64f, -0.3f, 0.93f, -0.46f)
                curveTo(22.59f, 15.5f, 23.0f, 14.83f, 23.0f, 14.09f)
                verticalLineTo(9.91f)
                curveTo(23.0f, 9.17f, 22.59f, 8.5f, 21.95f, 8.15f)
                close()
                moveTo(12.0f, 4.0f)
                curveToRelative(2.37f, 0.0f, 4.49f, 1.04f, 5.95f, 2.68f)
                curveTo(16.17f, 6.25f, 14.15f, 6.0f, 12.0f, 6.0f)
                curveTo(9.85f, 6.0f, 7.83f, 6.25f, 6.05f, 6.68f)
                curveTo(7.51f, 5.04f, 9.63f, 4.0f, 12.0f, 4.0f)
                close()
                moveTo(12.0f, 20.0f)
                curveToRelative(-2.37f, 0.0f, -4.49f, -1.04f, -5.95f, -2.68f)
                curveTo(7.83f, 17.75f, 9.85f, 18.0f, 12.0f, 18.0f)
                reflectiveCurveToRelative(4.17f, -0.25f, 5.95f, -0.68f)
                curveTo(16.49f, 18.96f, 14.37f, 20.0f, 12.0f, 20.0f)
                close()
            }
        }
        return _panoramaPhotosphereSelect!!
    }

private var _panoramaPhotosphereSelect: ImageVector? = null
