/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.PlayDisabled: ImageVector
    get() {
        if (_playDisabled != null) {
            return _playDisabled!!
        }
        _playDisabled = materialIcon(name = "Outlined.PlayDisabled") {
            materialPath {
                moveTo(16.45f, 13.62f)
                lineToRelative(2.55f, -1.62f)
                lineToRelative(-11.0f, -7.0f)
                lineToRelative(0.0f, 0.17f)
                close()
            }
            materialPath {
                moveTo(2.81f, 2.81f)
                lineTo(1.39f, 4.22f)
                lineTo(8.0f, 10.83f)
                verticalLineTo(19.0f)
                lineToRelative(4.99f, -3.18f)
                lineToRelative(6.78f, 6.78f)
                lineToRelative(1.41f, -1.41f)
                lineTo(2.81f, 2.81f)
                close()
                moveTo(10.0f, 15.36f)
                verticalLineToRelative(-2.53f)
                lineToRelative(1.55f, 1.55f)
                lineTo(10.0f, 15.36f)
                close()
            }
        }
        return _playDisabled!!
    }

private var _playDisabled: ImageVector? = null
