/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.TimerOff: ImageVector
    get() {
        if (_timerOff != null) {
            return _timerOff!!
        }
        _timerOff = materialIcon(name = "Outlined.TimerOff") {
            materialPath {
                moveTo(11.0f, 8.0f)
                verticalLineToRelative(0.86f)
                lineToRelative(2.0f, 2.0f)
                lineTo(13.0f, 8.0f)
                close()
                moveTo(9.0f, 1.0f)
                horizontalLineToRelative(6.0f)
                verticalLineToRelative(2.0f)
                lineTo(9.0f, 3.0f)
                close()
                moveTo(12.0f, 6.0f)
                curveToRelative(3.87f, 0.0f, 7.0f, 3.13f, 7.0f, 7.0f)
                curveToRelative(0.0f, 1.12f, -0.27f, 2.18f, -0.74f, 3.12f)
                lineToRelative(1.47f, 1.47f)
                curveTo(20.53f, 16.25f, 21.0f, 14.68f, 21.0f, 13.0f)
                curveToRelative(0.0f, -2.12f, -0.74f, -4.07f, -1.97f, -5.61f)
                lineToRelative(1.42f, -1.42f)
                curveToRelative(-0.43f, -0.51f, -0.9f, -0.99f, -1.41f, -1.41f)
                lineToRelative(-1.42f, 1.42f)
                curveTo(16.07f, 4.74f, 14.12f, 4.0f, 12.0f, 4.0f)
                curveToRelative(-1.68f, 0.0f, -3.25f, 0.47f, -4.59f, 1.27f)
                lineToRelative(1.47f, 1.47f)
                curveToRelative(0.94f, -0.47f, 2.0f, -0.74f, 3.12f, -0.74f)
                close()
                moveTo(3.16f, 3.86f)
                lineTo(1.75f, 5.27f)
                lineTo(4.5f, 8.02f)
                curveTo(3.56f, 9.45f, 3.0f, 11.16f, 3.0f, 13.0f)
                curveToRelative(0.0f, 4.97f, 4.02f, 9.0f, 9.0f, 9.0f)
                curveToRelative(1.84f, 0.0f, 3.55f, -0.55f, 4.98f, -1.5f)
                lineToRelative(2.5f, 2.5f)
                lineToRelative(1.41f, -1.41f)
                lineTo(3.16f, 3.86f)
                close()
                moveTo(12.0f, 20.0f)
                curveToRelative(-3.87f, 0.0f, -7.0f, -3.13f, -7.0f, -7.0f)
                curveToRelative(0.0f, -1.29f, 0.35f, -2.49f, 0.96f, -3.52f)
                lineToRelative(9.57f, 9.57f)
                curveToRelative(-1.04f, 0.6f, -2.24f, 0.95f, -3.53f, 0.95f)
                close()
            }
        }
        return _timerOff!!
    }

private var _timerOff: ImageVector? = null
