/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.BeachAccess: ImageVector
    get() {
        if (_beachAccess != null) {
            return _beachAccess!!
        }
        _beachAccess = materialIcon(name = "Rounded.BeachAccess") {
            materialPath {
                moveTo(13.13f, 14.56f)
                lineToRelative(1.43f, -1.43f)
                lineToRelative(5.73f, 5.73f)
                curveToRelative(0.39f, 0.39f, 0.39f, 1.03f, 0.0f, 1.43f)
                curveToRelative(-0.39f, 0.39f, -1.03f, 0.39f, -1.43f, 0.0f)
                lineToRelative(-5.73f, -5.73f)
                close()
                moveTo(17.42f, 8.83f)
                lineToRelative(1.27f, -1.27f)
                curveToRelative(0.89f, -0.89f, 0.77f, -2.43f, -0.31f, -3.08f)
                curveToRelative(-3.89f, -2.38f, -9.03f, -1.89f, -12.4f, 1.47f)
                curveToRelative(3.93f, -1.3f, 8.31f, -0.25f, 11.44f, 2.88f)
                close()
                moveTo(5.95f, 5.98f)
                curveToRelative(-3.36f, 3.37f, -3.85f, 8.51f, -1.48f, 12.4f)
                curveToRelative(0.66f, 1.08f, 2.19f, 1.21f, 3.08f, 0.31f)
                lineToRelative(1.27f, -1.27f)
                curveTo(5.7f, 14.29f, 4.65f, 9.91f, 5.95f, 5.98f)
                close()
                moveTo(5.97f, 5.96f)
                lineToRelative(-0.01f, 0.01f)
                curveToRelative(-0.38f, 3.01f, 1.17f, 6.88f, 4.3f, 10.02f)
                lineToRelative(5.73f, -5.73f)
                curveToRelative(-3.13f, -3.13f, -7.01f, -4.68f, -10.02f, -4.3f)
                close()
            }
        }
        return _beachAccess!!
    }

private var _beachAccess: ImageVector? = null
