/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.DeviceHub: ImageVector
    get() {
        if (_deviceHub != null) {
            return _deviceHub!!
        }
        _deviceHub = materialIcon(name = "Rounded.DeviceHub") {
            materialPath {
                moveTo(17.0f, 16.0f)
                lineToRelative(-4.0f, -4.0f)
                verticalLineTo(8.82f)
                curveToRelative(1.35f, -0.49f, 2.26f, -1.89f, 1.93f, -3.46f)
                curveToRelative(-0.25f, -1.18f, -1.23f, -2.12f, -2.42f, -2.32f)
                curveTo(10.63f, 2.73f, 9.0f, 4.17f, 9.0f, 6.0f)
                curveToRelative(0.0f, 1.3f, 0.84f, 2.4f, 2.0f, 2.82f)
                verticalLineTo(12.0f)
                lineToRelative(-4.0f, 4.0f)
                horizontalLineTo(4.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(3.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(3.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(-2.05f)
                lineToRelative(4.0f, -4.2f)
                lineToRelative(4.0f, 4.2f)
                verticalLineTo(20.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(3.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(-3.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(-3.0f)
                close()
            }
        }
        return _deviceHub!!
    }

private var _deviceHub: ImageVector? = null
