/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Flight: ImageVector
    get() {
        if (_flight != null) {
            return _flight!!
        }
        _flight = materialIcon(name = "Rounded.Flight") {
            materialPath {
                moveTo(21.0f, 14.58f)
                curveToRelative(0.0f, -0.36f, -0.19f, -0.69f, -0.49f, -0.89f)
                lineTo(13.0f, 9.0f)
                verticalLineTo(3.5f)
                curveToRelative(0.0f, -0.83f, -0.67f, -1.5f, -1.5f, -1.5f)
                reflectiveCurveTo(10.0f, 2.67f, 10.0f, 3.5f)
                verticalLineTo(9.0f)
                lineToRelative(-7.51f, 4.69f)
                curveToRelative(-0.3f, 0.19f, -0.49f, 0.53f, -0.49f, 0.89f)
                curveToRelative(0.0f, 0.7f, 0.68f, 1.21f, 1.36f, 1.0f)
                lineTo(10.0f, 13.5f)
                verticalLineTo(19.0f)
                lineToRelative(-1.8f, 1.35f)
                curveToRelative(-0.13f, 0.09f, -0.2f, 0.24f, -0.2f, 0.4f)
                verticalLineToRelative(0.59f)
                curveToRelative(0.0f, 0.33f, 0.32f, 0.57f, 0.64f, 0.48f)
                lineTo(11.5f, 21.0f)
                lineToRelative(2.86f, 0.82f)
                curveToRelative(0.32f, 0.09f, 0.64f, -0.15f, 0.64f, -0.48f)
                verticalLineToRelative(-0.59f)
                curveToRelative(0.0f, -0.16f, -0.07f, -0.31f, -0.2f, -0.4f)
                lineTo(13.0f, 19.0f)
                verticalLineToRelative(-5.5f)
                lineToRelative(6.64f, 2.08f)
                curveToRelative(0.68f, 0.21f, 1.36f, -0.3f, 1.36f, -1.0f)
                close()
            }
        }
        return _flight!!
    }

private var _flight: ImageVector? = null
