/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.FontDownloadOff: ImageVector
    get() {
        if (_fontDownloadOff != null) {
            return _fontDownloadOff!!
        }
        _fontDownloadOff = materialIcon(name = "Rounded.FontDownloadOff") {
            materialPath {
                moveTo(12.58f, 9.75f)
                lineToRelative(-0.87f, -0.87f)
                lineToRelative(0.23f, -0.66f)
                horizontalLineToRelative(0.1f)
                lineTo(12.58f, 9.75f)
                close()
                moveTo(10.35f, 7.52f)
                lineTo(10.55f, 7.0f)
                curveToRelative(0.23f, -0.6f, 0.8f, -1.0f, 1.45f, -1.0f)
                reflectiveCurveToRelative(1.22f, 0.4f, 1.45f, 1.0f)
                lineToRelative(2.17f, 5.79f)
                lineTo(22.0f, 19.17f)
                verticalLineTo(4.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                horizontalLineTo(4.83f)
                lineTo(10.35f, 7.52f)
                close()
                moveTo(21.19f, 22.61f)
                lineTo(21.19f, 22.61f)
                curveToRelative(-0.39f, 0.39f, -1.02f, 0.39f, -1.41f, 0.0f)
                lineTo(19.17f, 22.0f)
                horizontalLineTo(4.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, -0.9f, -2.0f, -2.0f)
                verticalLineTo(4.83f)
                lineTo(1.39f, 4.22f)
                curveTo(1.0f, 3.83f, 1.0f, 3.2f, 1.39f, 2.81f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.39f, -0.39f, 1.02f, -0.39f, 1.41f, 0.0f)
                lineToRelative(18.38f, 18.38f)
                curveTo(21.58f, 21.58f, 21.58f, 22.22f, 21.19f, 22.61f)
                close()
                moveTo(12.1f, 14.93f)
                lineToRelative(-3.3f, -3.3f)
                lineTo(6.9f, 16.7f)
                curveTo(6.67f, 17.33f, 7.13f, 18.0f, 7.8f, 18.0f)
                horizontalLineToRelative(0.01f)
                curveToRelative(0.41f, 0.0f, 0.77f, -0.26f, 0.9f, -0.64f)
                lineToRelative(0.86f, -2.43f)
                horizontalLineTo(12.1f)
                close()
            }
        }
        return _fontDownloadOff!!
    }

private var _fontDownloadOff: ImageVector? = null
