/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.HotelClass: ImageVector
    get() {
        if (_hotelClass != null) {
            return _hotelClass!!
        }
        _hotelClass = materialIcon(name = "Rounded.HotelClass") {
            materialPath {
                moveTo(8.58f, 10.0f)
                horizontalLineTo(2.56f)
                curveToRelative(-0.49f, 0.0f, -0.69f, 0.62f, -0.29f, 0.91f)
                lineToRelative(4.91f, 3.51f)
                lineToRelative(-1.89f, 6.1f)
                curveToRelative(-0.14f, 0.46f, 0.39f, 0.84f, 0.78f, 0.55f)
                lineTo(11.0f, 17.31f)
                lineToRelative(4.93f, 3.75f)
                curveToRelative(0.39f, 0.29f, 0.92f, -0.08f, 0.78f, -0.55f)
                lineToRelative(-1.89f, -6.1f)
                lineToRelative(4.91f, -3.51f)
                curveToRelative(0.4f, -0.28f, 0.2f, -0.91f, -0.29f, -0.91f)
                horizontalLineToRelative(-6.02f)
                lineToRelative(-1.95f, -6.42f)
                curveToRelative(-0.14f, -0.47f, -0.81f, -0.47f, -0.96f, 0.0f)
                lineTo(8.58f, 10.0f)
                close()
                moveTo(20.9f, 20.51f)
                lineToRelative(-1.4f, -4.52f)
                lineToRelative(2.91f, -2.08f)
                curveToRelative(0.4f, -0.28f, 0.2f, -0.91f, -0.29f, -0.91f)
                horizontalLineToRelative(-1.88f)
                lineToRelative(-3.08f, 2.2f)
                lineToRelative(1.46f, 4.72f)
                lineToRelative(1.5f, 1.14f)
                curveTo(20.51f, 21.35f, 21.04f, 20.97f, 20.9f, 20.51f)
                close()
                moveTo(17.0f, 8.0f)
                lineToRelative(-1.34f, -4.42f)
                curveToRelative(-0.14f, -0.47f, -0.81f, -0.47f, -0.96f, 0.0f)
                lineToRelative(-0.57f, 1.87f)
                lineTo(14.91f, 8.0f)
                horizontalLineTo(17.0f)
                close()
            }
        }
        return _hotelClass!!
    }

private var _hotelClass: ImageVector? = null
