/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.HourglassDisabled: ImageVector
    get() {
        if (_hourglassDisabled != null) {
            return _hourglassDisabled!!
        }
        _hourglassDisabled = materialIcon(name = "Rounded.HourglassDisabled") {
            materialPath {
                moveTo(2.81f, 2.81f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, 0.0f)
                curveTo(1.0f, 3.2f, 1.0f, 3.83f, 1.39f, 4.22f)
                lineToRelative(8.19f, 8.19f)
                lineToRelative(-3.0f, 3.01f)
                curveTo(6.21f, 15.8f, 6.0f, 16.31f, 6.0f, 16.84f)
                verticalLineTo(20.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(8.0f)
                curveToRelative(0.86f, 0.0f, 1.58f, -0.54f, 1.87f, -1.3f)
                lineToRelative(1.91f, 1.91f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                curveToRelative(0.39f, -0.39f, 0.39f, -1.02f, 0.0f, -1.41f)
                lineTo(2.81f, 2.81f)
                close()
                moveTo(16.0f, 19.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                horizontalLineTo(9.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                verticalLineToRelative(-2.5f)
                lineToRelative(2.84f, -2.84f)
                lineTo(16.0f, 18.83f)
                verticalLineTo(19.0f)
                close()
            }
            materialPath {
                moveTo(8.0f, 5.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                horizontalLineToRelative(6.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineToRelative(2.5f)
                lineToRelative(-2.84f, 2.84f)
                lineToRelative(1.25f, 1.25f)
                lineToRelative(3.0f, -2.99f)
                curveTo(17.79f, 8.22f, 18.0f, 7.71f, 18.0f, 7.18f)
                verticalLineTo(4.0f)
                curveToRelative(0.0f, -1.11f, -0.9f, -2.0f, -2.0f, -2.0f)
                horizontalLineTo(8.0f)
                curveTo(7.14f, 2.0f, 6.42f, 2.54f, 6.13f, 3.3f)
                lineTo(8.0f, 5.17f)
                verticalLineTo(5.0f)
                close()
            }
        }
        return _hourglassDisabled!!
    }

private var _hourglassDisabled: ImageVector? = null
