/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.PhonelinkSetup: ImageVector
    get() {
        if (_phonelinkSetup != null) {
            return _phonelinkSetup!!
        }
        _phonelinkSetup = materialIcon(name = "Rounded.PhonelinkSetup") {
            materialPath {
                moveTo(7.0f, 3.0f)
                verticalLineToRelative(2.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                reflectiveCurveToRelative(1.0f, -0.45f, 1.0f, -1.0f)
                lineTo(9.0f, 4.0f)
                horizontalLineToRelative(10.0f)
                verticalLineToRelative(16.0f)
                lineTo(9.0f, 20.0f)
                verticalLineToRelative(-1.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                reflectiveCurveToRelative(-1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(2.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(10.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                lineTo(21.0f, 3.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                lineTo(9.0f, 1.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                close()
                moveTo(9.5f, 15.5f)
                curveToRelative(0.29f, -0.12f, 0.55f, -0.29f, 0.8f, -0.48f)
                lineToRelative(-0.02f, 0.03f)
                lineToRelative(1.01f, 0.39f)
                curveToRelative(0.23f, 0.09f, 0.49f, 0.0f, 0.61f, -0.22f)
                lineToRelative(0.84f, -1.46f)
                curveToRelative(0.12f, -0.21f, 0.07f, -0.49f, -0.12f, -0.64f)
                lineToRelative(-0.85f, -0.68f)
                lineToRelative(-0.02f, 0.03f)
                curveToRelative(0.02f, -0.16f, 0.05f, -0.32f, 0.05f, -0.48f)
                reflectiveCurveToRelative(-0.03f, -0.32f, -0.05f, -0.48f)
                lineToRelative(0.02f, 0.03f)
                lineToRelative(0.85f, -0.68f)
                curveToRelative(0.19f, -0.15f, 0.24f, -0.43f, 0.12f, -0.64f)
                lineToRelative(-0.84f, -1.46f)
                curveToRelative(-0.12f, -0.21f, -0.38f, -0.31f, -0.61f, -0.22f)
                lineToRelative(-1.01f, 0.39f)
                lineToRelative(0.02f, 0.03f)
                curveToRelative(-0.25f, -0.17f, -0.51f, -0.34f, -0.8f, -0.46f)
                lineToRelative(-0.17f, -1.08f)
                curveTo(9.3f, 7.18f, 9.09f, 7.0f, 8.84f, 7.0f)
                lineTo(7.16f, 7.0f)
                curveToRelative(-0.25f, 0.0f, -0.46f, 0.18f, -0.49f, 0.42f)
                lineTo(6.5f, 8.5f)
                curveToRelative(-0.29f, 0.12f, -0.55f, 0.29f, -0.8f, 0.48f)
                lineToRelative(0.02f, -0.03f)
                lineToRelative(-1.02f, -0.39f)
                curveToRelative(-0.23f, -0.09f, -0.49f, 0.0f, -0.61f, 0.22f)
                lineToRelative(-0.84f, 1.46f)
                curveToRelative(-0.12f, 0.21f, -0.07f, 0.49f, 0.12f, 0.64f)
                lineToRelative(0.85f, 0.68f)
                lineToRelative(0.02f, -0.03f)
                curveToRelative(-0.02f, 0.15f, -0.05f, 0.31f, -0.05f, 0.47f)
                reflectiveCurveToRelative(0.03f, 0.32f, 0.05f, 0.48f)
                lineToRelative(-0.02f, -0.03f)
                lineToRelative(-0.85f, 0.68f)
                curveToRelative(-0.19f, 0.15f, -0.24f, 0.43f, -0.12f, 0.64f)
                lineToRelative(0.84f, 1.46f)
                curveToRelative(0.12f, 0.21f, 0.38f, 0.31f, 0.61f, 0.22f)
                lineToRelative(1.01f, -0.39f)
                lineToRelative(-0.01f, -0.04f)
                curveToRelative(0.25f, 0.19f, 0.51f, 0.36f, 0.8f, 0.48f)
                lineToRelative(0.17f, 1.07f)
                curveToRelative(0.03f, 0.25f, 0.24f, 0.43f, 0.49f, 0.43f)
                horizontalLineToRelative(1.68f)
                curveToRelative(0.25f, 0.0f, 0.46f, -0.18f, 0.49f, -0.42f)
                lineToRelative(0.17f, -1.08f)
                close()
                moveTo(6.0f, 12.0f)
                curveToRelative(0.0f, -1.1f, 0.9f, -2.0f, 2.0f, -2.0f)
                reflectiveCurveToRelative(2.0f, 0.9f, 2.0f, 2.0f)
                reflectiveCurveToRelative(-0.9f, 2.0f, -2.0f, 2.0f)
                reflectiveCurveToRelative(-2.0f, -0.9f, -2.0f, -2.0f)
                close()
            }
        }
        return _phonelinkSetup!!
    }

private var _phonelinkSetup: ImageVector? = null
