/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.RoomPreferences: ImageVector
    get() {
        if (_roomPreferences != null) {
            return _roomPreferences!!
        }
        _roomPreferences = materialIcon(name = "Rounded.RoomPreferences") {
            materialPath {
                moveTo(21.75f, 17.0f)
                curveToRelative(0.0f, -0.22f, -0.03f, -0.42f, -0.06f, -0.63f)
                lineToRelative(0.84f, -0.73f)
                curveToRelative(0.18f, -0.16f, 0.22f, -0.42f, 0.1f, -0.63f)
                lineToRelative(-0.59f, -1.02f)
                curveToRelative(-0.12f, -0.21f, -0.37f, -0.3f, -0.59f, -0.22f)
                lineToRelative(-1.06f, 0.36f)
                curveToRelative(-0.32f, -0.27f, -0.68f, -0.48f, -1.08f, -0.63f)
                lineToRelative(-0.22f, -1.09f)
                curveToRelative(-0.05f, -0.23f, -0.25f, -0.4f, -0.49f, -0.4f)
                horizontalLineToRelative(-1.18f)
                curveToRelative(-0.24f, 0.0f, -0.44f, 0.17f, -0.49f, 0.4f)
                lineToRelative(-0.22f, 1.09f)
                curveToRelative(-0.4f, 0.15f, -0.76f, 0.36f, -1.08f, 0.63f)
                lineToRelative(-1.06f, -0.36f)
                curveToRelative(-0.23f, -0.08f, -0.47f, 0.02f, -0.59f, 0.22f)
                lineToRelative(-0.59f, 1.02f)
                curveToRelative(-0.12f, 0.21f, -0.08f, 0.47f, 0.1f, 0.63f)
                lineToRelative(0.84f, 0.73f)
                curveToRelative(-0.03f, 0.21f, -0.06f, 0.41f, -0.06f, 0.63f)
                reflectiveCurveToRelative(0.03f, 0.42f, 0.06f, 0.63f)
                lineToRelative(-0.84f, 0.73f)
                curveToRelative(-0.18f, 0.16f, -0.22f, 0.42f, -0.1f, 0.63f)
                lineToRelative(0.59f, 1.02f)
                curveToRelative(0.12f, 0.21f, 0.37f, 0.3f, 0.59f, 0.22f)
                lineToRelative(1.06f, -0.36f)
                curveToRelative(0.32f, 0.27f, 0.68f, 0.48f, 1.08f, 0.63f)
                lineToRelative(0.22f, 1.09f)
                curveToRelative(0.05f, 0.23f, 0.25f, 0.4f, 0.49f, 0.4f)
                horizontalLineToRelative(1.18f)
                curveToRelative(0.24f, 0.0f, 0.44f, -0.17f, 0.49f, -0.4f)
                lineToRelative(0.22f, -1.09f)
                curveToRelative(0.4f, -0.15f, 0.76f, -0.36f, 1.08f, -0.63f)
                lineToRelative(1.06f, 0.36f)
                curveToRelative(0.23f, 0.08f, 0.47f, -0.02f, 0.59f, -0.22f)
                lineToRelative(0.59f, -1.02f)
                curveToRelative(0.12f, -0.21f, 0.08f, -0.47f, -0.1f, -0.63f)
                lineToRelative(-0.84f, -0.73f)
                curveTo(21.72f, 17.42f, 21.75f, 17.22f, 21.75f, 17.0f)
                close()
                moveTo(18.0f, 19.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, -0.9f, -2.0f, -2.0f)
                reflectiveCurveToRelative(0.9f, -2.0f, 2.0f, -2.0f)
                reflectiveCurveToRelative(2.0f, 0.9f, 2.0f, 2.0f)
                reflectiveCurveTo(19.1f, 19.0f, 18.0f, 19.0f)
                close()
                moveTo(14.0f, 11.26f)
                verticalLineTo(6.0f)
                horizontalLineToRelative(3.0f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(5.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(-4.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineTo(6.0f)
                curveTo(5.45f, 3.0f, 5.0f, 3.45f, 5.0f, 4.0f)
                verticalLineToRelative(15.0f)
                horizontalLineTo(4.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                reflectiveCurveToRelative(0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(8.26f)
                curveTo(11.47f, 19.87f, 11.0f, 18.49f, 11.0f, 17.0f)
                curveTo(11.0f, 14.62f, 12.19f, 12.53f, 14.0f, 11.26f)
                close()
                moveTo(10.0f, 12.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                reflectiveCurveTo(10.0f, 12.55f, 10.0f, 12.0f)
                close()
            }
        }
        return _roomPreferences!!
    }

private var _roomPreferences: ImageVector? = null
