/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Tapas: ImageVector
    get() {
        if (_tapas != null) {
            return _tapas!!
        }
        _tapas = materialIcon(name = "Rounded.Tapas") {
            materialPath {
                moveTo(22.0f, 10.0f)
                verticalLineTo(2.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(-6.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(8.0f)
                curveToRelative(0.0f, 1.86f, 1.28f, 3.41f, 3.0f, 3.86f)
                verticalLineTo(21.0f)
                horizontalLineToRelative(-1.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(4.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineToRelative(-7.14f)
                curveTo(20.72f, 13.41f, 22.0f, 11.86f, 22.0f, 10.0f)
                close()
                moveTo(20.0f, 3.0f)
                verticalLineToRelative(3.0f)
                horizontalLineToRelative(-4.0f)
                verticalLineTo(3.0f)
                horizontalLineTo(20.0f)
                close()
                moveTo(9.86f, 9.0f)
                lineTo(8.0f, 9.0f)
                verticalLineTo(8.0f)
                lineToRelative(1.86f, 0.0f)
                curveToRelative(1.31f, 0.0f, 2.5f, -0.94f, 2.63f, -2.24f)
                curveTo(12.64f, 4.26f, 11.47f, 3.0f, 10.0f, 3.0f)
                horizontalLineTo(8.0f)
                verticalLineTo(2.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(0.0f)
                curveTo(6.45f, 1.0f, 6.0f, 1.45f, 6.0f, 2.0f)
                verticalLineToRelative(1.0f)
                lineTo(4.14f, 3.0f)
                curveToRelative(-1.31f, 0.0f, -2.5f, 0.94f, -2.63f, 2.24f)
                curveTo(1.36f, 6.74f, 2.53f, 8.0f, 4.0f, 8.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(1.0f)
                lineTo(4.14f, 9.0f)
                curveToRelative(-1.31f, 0.0f, -2.5f, 0.94f, -2.63f, 2.24f)
                curveTo(1.36f, 12.74f, 2.53f, 14.0f, 4.0f, 14.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(8.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(-8.0f)
                horizontalLineToRelative(2.0f)
                curveToRelative(1.47f, 0.0f, 2.64f, -1.26f, 2.49f, -2.76f)
                curveTo(12.36f, 9.94f, 11.17f, 9.0f, 9.86f, 9.0f)
                close()
            }
        }
        return _tapas!!
    }

private var _tapas: ImageVector? = null
