/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded._4kPlus: ImageVector
    get() {
        if (__4kPlus != null) {
            return __4kPlus!!
        }
        __4kPlus = materialIcon(name = "Rounded._4kPlus") {
            materialPath {
                moveTo(19.0f, 3.0f)
                horizontalLineTo(5.0f)
                curveTo(3.9f, 3.0f, 3.0f, 3.9f, 3.0f, 5.0f)
                verticalLineToRelative(14.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(14.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(5.0f)
                curveTo(21.0f, 3.9f, 20.1f, 3.0f, 19.0f, 3.0f)
                close()
                moveTo(10.25f, 13.5f)
                horizontalLineTo(10.0f)
                verticalLineToRelative(0.75f)
                curveTo(10.0f, 14.66f, 9.66f, 15.0f, 9.25f, 15.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(-0.41f, 0.0f, -0.75f, -0.34f, -0.75f, -0.75f)
                verticalLineTo(13.5f)
                horizontalLineToRelative(-2.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                verticalLineTo(9.75f)
                curveTo(5.5f, 9.34f, 5.84f, 9.0f, 6.25f, 9.0f)
                horizontalLineToRelative(0.0f)
                curveTo(6.66f, 9.0f, 7.0f, 9.34f, 7.0f, 9.75f)
                verticalLineTo(12.0f)
                horizontalLineToRelative(1.5f)
                verticalLineTo(9.75f)
                curveTo(8.5f, 9.34f, 8.84f, 9.0f, 9.25f, 9.0f)
                horizontalLineToRelative(0.0f)
                curveTo(9.66f, 9.0f, 10.0f, 9.34f, 10.0f, 9.75f)
                verticalLineTo(12.0f)
                horizontalLineToRelative(0.25f)
                curveToRelative(0.41f, 0.0f, 0.75f, 0.34f, 0.75f, 0.75f)
                verticalLineToRelative(0.0f)
                curveTo(11.0f, 13.16f, 10.66f, 13.5f, 10.25f, 13.5f)
                close()
                moveTo(15.09f, 15.0f)
                lineTo(15.09f, 15.0f)
                curveToRelative(-0.22f, 0.0f, -0.42f, -0.1f, -0.55f, -0.27f)
                lineTo(13.0f, 12.75f)
                verticalLineToRelative(1.55f)
                curveToRelative(0.0f, 0.39f, -0.31f, 0.7f, -0.7f, 0.7f)
                horizontalLineTo(12.2f)
                curveToRelative(-0.39f, 0.0f, -0.7f, -0.31f, -0.7f, -0.7f)
                verticalLineTo(9.7f)
                curveToRelative(0.0f, -0.39f, 0.31f, -0.7f, 0.7f, -0.7f)
                horizontalLineToRelative(0.09f)
                curveTo(12.69f, 9.0f, 13.0f, 9.31f, 13.0f, 9.7f)
                verticalLineToRelative(1.55f)
                lineToRelative(1.54f, -1.98f)
                curveTo(14.67f, 9.1f, 14.88f, 9.0f, 15.09f, 9.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(0.58f, 0.0f, 0.91f, 0.66f, 0.56f, 1.12f)
                lineTo(14.25f, 12.0f)
                lineToRelative(1.41f, 1.88f)
                curveTo(16.0f, 14.34f, 15.67f, 15.0f, 15.09f, 15.0f)
                close()
                moveTo(18.5f, 12.5f)
                horizontalLineToRelative(-1.0f)
                verticalLineToRelative(1.0f)
                curveToRelative(0.0f, 0.28f, -0.22f, 0.5f, -0.5f, 0.5f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(-0.28f, 0.0f, -0.5f, -0.22f, -0.5f, -0.5f)
                verticalLineToRelative(-1.0f)
                horizontalLineToRelative(-1.0f)
                curveToRelative(-0.28f, 0.0f, -0.5f, -0.22f, -0.5f, -0.5f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, -0.28f, 0.22f, -0.5f, 0.5f, -0.5f)
                horizontalLineToRelative(1.0f)
                verticalLineToRelative(-1.0f)
                curveToRelative(0.0f, -0.28f, 0.22f, -0.5f, 0.5f, -0.5f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.28f, 0.0f, 0.5f, 0.22f, 0.5f, 0.5f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(1.0f)
                curveToRelative(0.28f, 0.0f, 0.5f, 0.22f, 0.5f, 0.5f)
                verticalLineToRelative(0.0f)
                curveTo(19.0f, 12.28f, 18.78f, 12.5f, 18.5f, 12.5f)
                close()
            }
        }
        return __4kPlus!!
    }

private var __4kPlus: ImageVector? = null
