/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.Fitbit: ImageVector
    get() {
        if (_fitbit != null) {
            return _fitbit!!
        }
        _fitbit = materialIcon(name = "Sharp.Fitbit") {
            materialPath {
                moveTo(19.89f, 13.89f)
                curveToRelative(1.04f, 0.0f, 1.89f, -0.85f, 1.89f, -1.89f)
                reflectiveCurveToRelative(-0.85f, -1.89f, -1.89f, -1.89f)
                curveTo(18.85f, 10.11f, 18.0f, 10.96f, 18.0f, 12.0f)
                reflectiveCurveTo(18.85f, 13.89f, 19.89f, 13.89f)
                close()
                moveTo(15.65f, 13.68f)
                curveToRelative(0.93f, 0.0f, 1.68f, -0.75f, 1.68f, -1.68f)
                reflectiveCurveToRelative(-0.75f, -1.68f, -1.68f, -1.68f)
                curveToRelative(-0.93f, 0.0f, -1.68f, 0.75f, -1.68f, 1.68f)
                reflectiveCurveTo(14.72f, 13.68f, 15.65f, 13.68f)
                close()
                moveTo(15.65f, 9.42f)
                curveToRelative(0.93f, 0.0f, 1.68f, -0.75f, 1.68f, -1.68f)
                curveToRelative(0.0f, -0.93f, -0.75f, -1.68f, -1.68f, -1.68f)
                curveToRelative(-0.93f, 0.0f, -1.68f, 0.75f, -1.68f, 1.68f)
                curveTo(13.97f, 8.67f, 14.72f, 9.42f, 15.65f, 9.42f)
                close()
                moveTo(15.65f, 17.93f)
                curveToRelative(0.93f, 0.0f, 1.68f, -0.75f, 1.68f, -1.68f)
                curveToRelative(0.0f, -0.93f, -0.75f, -1.68f, -1.68f, -1.68f)
                curveToRelative(-0.93f, 0.0f, -1.68f, 0.75f, -1.68f, 1.68f)
                curveTo(13.97f, 17.17f, 14.72f, 17.93f, 15.65f, 17.93f)
                close()
                moveTo(11.41f, 13.47f)
                curveToRelative(0.81f, 0.0f, 1.47f, -0.66f, 1.47f, -1.47f)
                reflectiveCurveToRelative(-0.66f, -1.47f, -1.47f, -1.47f)
                curveToRelative(-0.81f, 0.0f, -1.47f, 0.66f, -1.47f, 1.47f)
                reflectiveCurveTo(10.59f, 13.47f, 11.41f, 13.47f)
                close()
                moveTo(11.41f, 9.21f)
                curveToRelative(0.81f, 0.0f, 1.47f, -0.66f, 1.47f, -1.47f)
                reflectiveCurveToRelative(-0.66f, -1.47f, -1.47f, -1.47f)
                curveToRelative(-0.81f, 0.0f, -1.47f, 0.66f, -1.47f, 1.47f)
                reflectiveCurveTo(10.59f, 9.21f, 11.41f, 9.21f)
                close()
                moveTo(11.41f, 17.73f)
                curveToRelative(0.81f, 0.0f, 1.47f, -0.66f, 1.47f, -1.47f)
                curveToRelative(0.0f, -0.81f, -0.66f, -1.47f, -1.47f, -1.47f)
                curveToRelative(-0.81f, 0.0f, -1.47f, 0.66f, -1.47f, 1.47f)
                curveTo(9.93f, 17.07f, 10.59f, 17.73f, 11.41f, 17.73f)
                close()
                moveTo(11.41f, 22.0f)
                curveToRelative(0.81f, 0.0f, 1.47f, -0.66f, 1.47f, -1.47f)
                curveToRelative(0.0f, -0.81f, -0.66f, -1.47f, -1.47f, -1.47f)
                curveToRelative(-0.81f, 0.0f, -1.47f, 0.66f, -1.47f, 1.47f)
                curveTo(9.93f, 21.34f, 10.59f, 22.0f, 11.41f, 22.0f)
                close()
                moveTo(11.41f, 4.94f)
                curveToRelative(0.81f, 0.0f, 1.47f, -0.66f, 1.47f, -1.47f)
                reflectiveCurveTo(12.22f, 2.0f, 11.41f, 2.0f)
                curveToRelative(-0.81f, 0.0f, -1.47f, 0.66f, -1.47f, 1.47f)
                reflectiveCurveTo(10.59f, 4.94f, 11.41f, 4.94f)
                close()
                moveTo(7.16f, 13.26f)
                curveToRelative(0.7f, 0.0f, 1.26f, -0.57f, 1.26f, -1.26f)
                reflectiveCurveToRelative(-0.57f, -1.26f, -1.26f, -1.26f)
                curveToRelative(-0.7f, 0.0f, -1.26f, 0.57f, -1.26f, 1.26f)
                reflectiveCurveTo(6.46f, 13.26f, 7.16f, 13.26f)
                close()
                moveTo(7.16f, 17.51f)
                curveToRelative(0.7f, 0.0f, 1.26f, -0.57f, 1.26f, -1.26f)
                curveToRelative(0.0f, -0.7f, -0.57f, -1.26f, -1.26f, -1.26f)
                curveToRelative(-0.7f, 0.0f, -1.26f, 0.57f, -1.26f, 1.26f)
                curveTo(5.9f, 16.94f, 6.46f, 17.51f, 7.16f, 17.51f)
                close()
                moveTo(7.16f, 9.02f)
                curveToRelative(0.7f, 0.0f, 1.26f, -0.57f, 1.26f, -1.26f)
                curveToRelative(0.0f, -0.7f, -0.57f, -1.26f, -1.26f, -1.26f)
                curveToRelative(-0.7f, 0.0f, -1.26f, 0.57f, -1.26f, 1.26f)
                curveTo(5.9f, 8.45f, 6.46f, 9.02f, 7.16f, 9.02f)
                close()
                moveTo(3.29f, 13.05f)
                curveToRelative(0.58f, 0.0f, 1.05f, -0.47f, 1.05f, -1.05f)
                reflectiveCurveToRelative(-0.47f, -1.05f, -1.05f, -1.05f)
                curveToRelative(-0.58f, 0.0f, -1.05f, 0.47f, -1.05f, 1.05f)
                reflectiveCurveTo(2.71f, 13.05f, 3.29f, 13.05f)
                close()
            }
        }
        return _fitbit!!
    }

private var _fitbit: ImageVector? = null
