/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.GppBad: ImageVector
    get() {
        if (_gppBad != null) {
            return _gppBad!!
        }
        _gppBad = materialIcon(name = "Sharp.GppBad") {
            materialPath {
                moveTo(12.0f, 2.0f)
                lineTo(4.0f, 5.0f)
                verticalLineToRelative(6.09f)
                curveToRelative(0.0f, 5.05f, 3.41f, 9.76f, 8.0f, 10.91f)
                curveToRelative(4.59f, -1.15f, 8.0f, -5.86f, 8.0f, -10.91f)
                verticalLineTo(5.0f)
                lineTo(12.0f, 2.0f)
                close()
                moveTo(15.5f, 14.09f)
                lineToRelative(-1.41f, 1.41f)
                lineTo(12.0f, 13.42f)
                lineTo(9.91f, 15.5f)
                lineTo(8.5f, 14.09f)
                lineTo(10.59f, 12.0f)
                lineTo(8.5f, 9.91f)
                lineTo(9.91f, 8.5f)
                lineTo(12.0f, 10.59f)
                lineToRelative(2.09f, -2.09f)
                lineToRelative(1.41f, 1.41f)
                lineTo(13.42f, 12.0f)
                lineTo(15.5f, 14.09f)
                close()
            }
        }
        return _gppBad!!
    }

private var _gppBad: ImageVector? = null
