/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.NoSim: ImageVector
    get() {
        if (_noSim != null) {
            return _noSim!!
        }
        _noSim = materialIcon(name = "Sharp.NoSim") {
            materialPath {
                moveTo(3.79f, 3.74f)
                lineTo(2.38f, 5.15f)
                lineToRelative(2.74f, 2.74f)
                lineToRelative(-0.12f, 0.12f)
                verticalLineTo(21.0f)
                horizontalLineToRelative(13.27f)
                lineToRelative(1.58f, 1.62f)
                lineToRelative(1.41f, -1.41f)
                close()
                moveTo(19.0f, 16.11f)
                verticalLineTo(3.0f)
                horizontalLineToRelative(-8.99f)
                lineTo(7.95f, 5.06f)
                close()
            }
        }
        return _noSim!!
    }

private var _noSim: ImageVector? = null
