/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.SouthAmerica: ImageVector
    get() {
        if (_southAmerica != null) {
            return _southAmerica!!
        }
        _southAmerica = materialIcon(name = "Sharp.SouthAmerica") {
            materialPath {
                moveTo(12.0f, 2.0f)
                curveTo(6.48f, 2.0f, 2.0f, 6.48f, 2.0f, 12.0f)
                curveToRelative(0.0f, 5.52f, 4.48f, 10.0f, 10.0f, 10.0f)
                reflectiveCurveToRelative(10.0f, -4.48f, 10.0f, -10.0f)
                curveTo(22.0f, 6.48f, 17.52f, 2.0f, 12.0f, 2.0f)
                close()
                moveTo(4.0f, 12.0f)
                curveToRelative(0.0f, -1.95f, 0.7f, -3.74f, 1.87f, -5.13f)
                lineTo(9.0f, 10.0f)
                verticalLineToRelative(1.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                verticalLineToRelative(5.59f)
                curveToRelative(0.0f, 0.27f, 0.11f, 0.52f, 0.29f, 0.71f)
                lineTo(12.0f, 20.0f)
                curveTo(7.58f, 20.0f, 4.0f, 16.42f, 4.0f, 12.0f)
                close()
                moveTo(13.0f, 19.94f)
                verticalLineTo(18.0f)
                lineToRelative(3.75f, -5.62f)
                curveToRelative(0.16f, -0.25f, 0.25f, -0.54f, 0.25f, -0.83f)
                verticalLineTo(10.5f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(-1.5f)
                lineToRelative(-1.4f, -1.75f)
                curveTo(12.72f, 7.28f, 12.15f, 7.0f, 11.54f, 7.0f)
                horizontalLineTo(8.0f)
                verticalLineTo(5.07f)
                curveTo(9.18f, 4.39f, 10.54f, 4.0f, 12.0f, 4.0f)
                curveToRelative(4.41f, 0.0f, 8.0f, 3.59f, 8.0f, 8.0f)
                curveTo(20.0f, 16.07f, 16.94f, 19.44f, 13.0f, 19.94f)
                close()
            }
        }
        return _southAmerica!!
    }

private var _southAmerica: ImageVector? = null
