/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.AddReaction: ImageVector
    get() {
        if (_addReaction != null) {
            return _addReaction!!
        }
        _addReaction = materialIcon(name = "TwoTone.AddReaction") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(19.41f, 9.0f)
                horizontalLineTo(18.0f)
                verticalLineTo(7.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineTo(5.08f)
                curveTo(14.82f, 4.4f, 13.46f, 4.0f, 12.0f, 4.0f)
                curveToRelative(-4.42f, 0.0f, -8.0f, 3.58f, -8.0f, 8.0f)
                reflectiveCurveToRelative(3.58f, 8.0f, 8.0f, 8.0f)
                reflectiveCurveToRelative(8.0f, -3.58f, 8.0f, -8.0f)
                curveTo(20.0f, 10.94f, 19.79f, 9.93f, 19.41f, 9.0f)
                close()
                moveTo(15.5f, 8.0f)
                curveTo(16.33f, 8.0f, 17.0f, 8.67f, 17.0f, 9.5f)
                curveToRelative(0.0f, 0.83f, -0.67f, 1.5f, -1.5f, 1.5f)
                reflectiveCurveTo(14.0f, 10.33f, 14.0f, 9.5f)
                curveTo(14.0f, 8.67f, 14.67f, 8.0f, 15.5f, 8.0f)
                close()
                moveTo(8.5f, 8.0f)
                curveTo(9.33f, 8.0f, 10.0f, 8.67f, 10.0f, 9.5f)
                curveToRelative(0.0f, 0.83f, -0.67f, 1.5f, -1.5f, 1.5f)
                reflectiveCurveTo(7.0f, 10.33f, 7.0f, 9.5f)
                curveTo(7.0f, 8.67f, 7.67f, 8.0f, 8.5f, 8.0f)
                close()
                moveTo(12.0f, 17.5f)
                curveToRelative(-2.33f, 0.0f, -4.31f, -1.46f, -5.11f, -3.5f)
                horizontalLineToRelative(10.22f)
                curveTo(16.31f, 16.04f, 14.33f, 17.5f, 12.0f, 17.5f)
                close()
            }
            materialPath {
                moveTo(7.0f, 9.5f)
                curveTo(7.0f, 8.67f, 7.67f, 8.0f, 8.5f, 8.0f)
                reflectiveCurveTo(10.0f, 8.67f, 10.0f, 9.5f)
                curveToRelative(0.0f, 0.83f, -0.67f, 1.5f, -1.5f, 1.5f)
                reflectiveCurveTo(7.0f, 10.33f, 7.0f, 9.5f)
                close()
                moveTo(12.0f, 17.5f)
                curveToRelative(2.33f, 0.0f, 4.31f, -1.46f, 5.11f, -3.5f)
                horizontalLineTo(6.89f)
                curveTo(7.69f, 16.04f, 9.67f, 17.5f, 12.0f, 17.5f)
                close()
                moveTo(15.5f, 11.0f)
                curveToRelative(0.83f, 0.0f, 1.5f, -0.67f, 1.5f, -1.5f)
                curveTo(17.0f, 8.67f, 16.33f, 8.0f, 15.5f, 8.0f)
                reflectiveCurveTo(14.0f, 8.67f, 14.0f, 9.5f)
                curveTo(14.0f, 10.33f, 14.67f, 11.0f, 15.5f, 11.0f)
                close()
                moveTo(22.0f, 1.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(5.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(3.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineTo(1.0f)
                close()
                moveTo(20.0f, 12.0f)
                curveToRelative(0.0f, 4.42f, -3.58f, 8.0f, -8.0f, 8.0f)
                reflectiveCurveToRelative(-8.0f, -3.58f, -8.0f, -8.0f)
                curveToRelative(0.0f, -4.42f, 3.58f, -8.0f, 8.0f, -8.0f)
                curveToRelative(1.46f, 0.0f, 2.82f, 0.4f, 4.0f, 1.08f)
                verticalLineTo(2.84f)
                curveTo(14.77f, 2.3f, 13.42f, 2.0f, 11.99f, 2.0f)
                curveTo(6.47f, 2.0f, 2.0f, 6.48f, 2.0f, 12.0f)
                curveToRelative(0.0f, 5.52f, 4.47f, 10.0f, 9.99f, 10.0f)
                curveTo(17.52f, 22.0f, 22.0f, 17.52f, 22.0f, 12.0f)
                curveToRelative(0.0f, -1.05f, -0.17f, -2.05f, -0.47f, -3.0f)
                horizontalLineToRelative(-2.13f)
                curveTo(19.78f, 9.93f, 20.0f, 10.94f, 20.0f, 12.0f)
                close()
            }
        }
        return _addReaction!!
    }

private var _addReaction: ImageVector? = null
