/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.CatchingPokemon: ImageVector
    get() {
        if (_catchingPokemon != null) {
            return _catchingPokemon!!
        }
        _catchingPokemon = materialIcon(name = "TwoTone.CatchingPokemon") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(12.0f, 4.0f)
                curveToRelative(4.08f, 0.0f, 7.45f, 3.05f, 7.94f, 7.0f)
                horizontalLineToRelative(-4.06f)
                curveTo(15.43f, 9.27f, 13.86f, 8.0f, 12.0f, 8.0f)
                reflectiveCurveToRelative(-3.43f, 1.27f, -3.87f, 3.0f)
                horizontalLineTo(4.06f)
                curveTo(4.55f, 7.05f, 7.92f, 4.0f, 12.0f, 4.0f)
                close()
            }
            materialPath {
                moveTo(12.0f, 2.0f)
                curveTo(6.48f, 2.0f, 2.0f, 6.48f, 2.0f, 12.0f)
                curveToRelative(0.0f, 5.52f, 4.48f, 10.0f, 10.0f, 10.0f)
                reflectiveCurveToRelative(10.0f, -4.48f, 10.0f, -10.0f)
                curveTo(22.0f, 6.48f, 17.52f, 2.0f, 12.0f, 2.0f)
                close()
                moveTo(12.0f, 4.0f)
                curveToRelative(4.08f, 0.0f, 7.45f, 3.05f, 7.94f, 7.0f)
                horizontalLineToRelative(-4.06f)
                curveTo(15.43f, 9.27f, 13.86f, 8.0f, 12.0f, 8.0f)
                reflectiveCurveToRelative(-3.43f, 1.27f, -3.87f, 3.0f)
                horizontalLineTo(4.06f)
                curveTo(4.55f, 7.05f, 7.92f, 4.0f, 12.0f, 4.0f)
                close()
                moveTo(14.0f, 12.0f)
                curveToRelative(0.0f, 1.1f, -0.9f, 2.0f, -2.0f, 2.0f)
                reflectiveCurveToRelative(-2.0f, -0.9f, -2.0f, -2.0f)
                curveToRelative(0.0f, -1.1f, 0.9f, -2.0f, 2.0f, -2.0f)
                reflectiveCurveTo(14.0f, 10.9f, 14.0f, 12.0f)
                close()
                moveTo(12.0f, 20.0f)
                curveToRelative(-4.08f, 0.0f, -7.45f, -3.05f, -7.94f, -7.0f)
                horizontalLineToRelative(4.06f)
                curveToRelative(0.44f, 1.73f, 2.01f, 3.0f, 3.87f, 3.0f)
                reflectiveCurveToRelative(3.43f, -1.27f, 3.87f, -3.0f)
                horizontalLineToRelative(4.06f)
                curveTo(19.45f, 16.95f, 16.08f, 20.0f, 12.0f, 20.0f)
                close()
            }
        }
        return _catchingPokemon!!
    }

private var _catchingPokemon: ImageVector? = null
