/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.Flare: ImageVector
    get() {
        if (_flare != null) {
            return _flare!!
        }
        _flare = materialIcon(name = "TwoTone.Flare") {
            materialPath {
                moveTo(5.644f, 7.05f)
                lineTo(7.05f, 5.645f)
                lineToRelative(2.123f, 2.122f)
                lineToRelative(-1.408f, 1.407f)
                close()
                moveTo(11.0f, 1.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(6.0f)
                horizontalLineToRelative(-2.0f)
                close()
                moveTo(16.242f, 14.834f)
                lineToRelative(2.12f, 2.12f)
                lineToRelative(-1.406f, 1.408f)
                lineToRelative(-2.12f, -2.12f)
                close()
                moveTo(14.834f, 7.76f)
                lineToRelative(2.12f, -2.123f)
                lineToRelative(1.41f, 1.407f)
                lineToRelative(-2.123f, 2.122f)
                close()
                moveTo(9.166f, 16.242f)
                lineToRelative(-2.122f, 2.12f)
                lineToRelative(-1.407f, -1.406f)
                lineToRelative(2.122f, -2.122f)
                close()
                moveTo(12.0f, 9.0f)
                curveToRelative(-1.66f, 0.0f, -3.0f, 1.34f, -3.0f, 3.0f)
                reflectiveCurveToRelative(1.34f, 3.0f, 3.0f, 3.0f)
                reflectiveCurveToRelative(3.0f, -1.34f, 3.0f, -3.0f)
                reflectiveCurveToRelative(-1.34f, -3.0f, -3.0f, -3.0f)
                close()
                moveTo(11.0f, 17.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(6.0f)
                horizontalLineToRelative(-2.0f)
                close()
                moveTo(1.0f, 11.0f)
                horizontalLineToRelative(6.0f)
                verticalLineToRelative(2.0f)
                lineTo(1.0f, 13.0f)
                close()
                moveTo(17.0f, 11.0f)
                horizontalLineToRelative(6.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-6.0f)
                close()
            }
        }
        return _flare!!
    }

private var _flare: ImageVector? = null
